<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Application StructType
 * @subpackage Structs
 */
class Application extends AbstractStructBase
{
    /**
     * The applicationId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $applicationId;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $status;
    /**
     * The serviceId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $serviceId;
    /**
     * The issuerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $issuerId;
    /**
     * The issueDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $issueDate;
    /**
     * The rcvDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $rcvDate;
    /**
     * The prdcRsltDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $prdcRsltDate;
    /**
     * The data
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApplicationDataWrapper
     */
    public $data;
    /**
     * The result
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ApplicationResultWrapper
     */
    public $result;
    /**
     * The errors
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BusinessErrorList
     */
    public $errors;
    /**
     * Constructor method for Application
     * @uses Application::setApplicationId()
     * @uses Application::setStatus()
     * @uses Application::setServiceId()
     * @uses Application::setIssuerId()
     * @uses Application::setIssueDate()
     * @uses Application::setRcvDate()
     * @uses Application::setPrdcRsltDate()
     * @uses Application::setData()
     * @uses Application::setResult()
     * @uses Application::setErrors()
     * @param string $applicationId
     * @param string $status
     * @param string $serviceId
     * @param string $issuerId
     * @param string $issueDate
     * @param string $rcvDate
     * @param string $prdcRsltDate
     * @param \StructType\ApplicationDataWrapper $data
     * @param \StructType\ApplicationResultWrapper $result
     * @param \StructType\BusinessErrorList $errors
     */
    public function __construct($applicationId = null, $status = null, $serviceId = null, $issuerId = null, $issueDate = null, $rcvDate = null, $prdcRsltDate = null, \StructType\ApplicationDataWrapper $data = null, \StructType\ApplicationResultWrapper $result = null, \StructType\BusinessErrorList $errors = null)
    {
        $this
            ->setApplicationId($applicationId)
            ->setStatus($status)
            ->setServiceId($serviceId)
            ->setIssuerId($issuerId)
            ->setIssueDate($issueDate)
            ->setRcvDate($rcvDate)
            ->setPrdcRsltDate($prdcRsltDate)
            ->setData($data)
            ->setResult($result)
            ->setErrors($errors);
    }
    /**
     * Get applicationId value
     * @return string|null
     */
    public function getApplicationId()
    {
        return $this->applicationId;
    }
    /**
     * Set applicationId value
     * @param string $applicationId
     * @return \StructType\Application
     */
    public function setApplicationId($applicationId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($applicationId) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($applicationId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($applicationId) && !is_string($applicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($applicationId)), __LINE__);
        }
        $this->applicationId = $applicationId;
        return $this;
    }
    /**
     * Get status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\ApplicationStatus::valueIsValid()
     * @uses \EnumType\ApplicationStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\Application
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ApplicationStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\ApplicationStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get serviceId value
     * @return string|null
     */
    public function getServiceId()
    {
        return $this->serviceId;
    }
    /**
     * Set serviceId value
     * @param string $serviceId
     * @return \StructType\Application
     */
    public function setServiceId($serviceId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceId) && !is_string($serviceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serviceId)), __LINE__);
        }
        $this->serviceId = $serviceId;
        return $this;
    }
    /**
     * Get issuerId value
     * @return string|null
     */
    public function getIssuerId()
    {
        return $this->issuerId;
    }
    /**
     * Set issuerId value
     * @param string $issuerId
     * @return \StructType\Application
     */
    public function setIssuerId($issuerId = null)
    {
        // validation for constraint: pattern
        if (is_scalar($issuerId) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($issuerId, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($issuerId) && !is_string($issuerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issuerId)), __LINE__);
        }
        $this->issuerId = $issuerId;
        return $this;
    }
    /**
     * Get issueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->issueDate;
    }
    /**
     * Set issueDate value
     * @param string $issueDate
     * @return \StructType\Application
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($issueDate)), __LINE__);
        }
        $this->issueDate = $issueDate;
        return $this;
    }
    /**
     * Get rcvDate value
     * @return string|null
     */
    public function getRcvDate()
    {
        return $this->rcvDate;
    }
    /**
     * Set rcvDate value
     * @param string $rcvDate
     * @return \StructType\Application
     */
    public function setRcvDate($rcvDate = null)
    {
        // validation for constraint: string
        if (!is_null($rcvDate) && !is_string($rcvDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($rcvDate)), __LINE__);
        }
        $this->rcvDate = $rcvDate;
        return $this;
    }
    /**
     * Get prdcRsltDate value
     * @return string|null
     */
    public function getPrdcRsltDate()
    {
        return $this->prdcRsltDate;
    }
    /**
     * Set prdcRsltDate value
     * @param string $prdcRsltDate
     * @return \StructType\Application
     */
    public function setPrdcRsltDate($prdcRsltDate = null)
    {
        // validation for constraint: string
        if (!is_null($prdcRsltDate) && !is_string($prdcRsltDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($prdcRsltDate)), __LINE__);
        }
        $this->prdcRsltDate = $prdcRsltDate;
        return $this;
    }
    /**
     * Get data value
     * @return \StructType\ApplicationDataWrapper|null
     */
    public function getData()
    {
        return $this->data;
    }
    /**
     * Set data value
     * @param \StructType\ApplicationDataWrapper $data
     * @return \StructType\Application
     */
    public function setData(\StructType\ApplicationDataWrapper $data = null)
    {
        $this->data = $data;
        return $this;
    }
    /**
     * Get result value
     * @return \StructType\ApplicationResultWrapper|null
     */
    public function getResult()
    {
        return $this->result;
    }
    /**
     * Set result value
     * @param \StructType\ApplicationResultWrapper $result
     * @return \StructType\Application
     */
    public function setResult(\StructType\ApplicationResultWrapper $result = null)
    {
        $this->result = $result;
        return $this;
    }
    /**
     * Get errors value
     * @return \StructType\BusinessErrorList|null
     */
    public function getErrors()
    {
        return $this->errors;
    }
    /**
     * Set errors value
     * @param \StructType\BusinessErrorList $errors
     * @return \StructType\Application
     */
    public function setErrors(\StructType\BusinessErrorList $errors = null)
    {
        $this->errors = $errors;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Application
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
