<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressObjectView StructType
 * Meta informations extracted from the WSDL
 * - documentation: Обертка для адресных объектов различного уровня (начиная с регионов страны, заканчивая улицами населенных пунктов)
 * @subpackage Structs
 */
class AddressObjectView extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название объекта (не содержит название типа объекта). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The englishName
     * Meta informations extracted from the WSDL
     * - documentation: Английское название объекта. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $englishName;
    /**
     * The view
     * Meta informations extracted from the WSDL
     * - documentation: Представление объекта (обычно это название + название типа объекта). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $view;
    /**
     * The regionCode
     * Meta informations extracted from the WSDL
     * - documentation: Код региона. Например, 33 - Владимирский регион
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $regionCode;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Название типа адресного объекта (например, область, район или город). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $type;
    /**
     * The countryGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор страны, к которой относится данный объект. | Тип, описывающий уникальный идентификатор любой
     * сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $countryGuid;
    /**
     * The hasStreets
     * Meta informations extracted from the WSDL
     * - documentation: Флаг, указывающий наличие улиц.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $hasStreets;
    /**
     * Constructor method for AddressObjectView
     * @uses AddressObjectView::setName()
     * @uses AddressObjectView::setEnglishName()
     * @uses AddressObjectView::setView()
     * @uses AddressObjectView::setRegionCode()
     * @uses AddressObjectView::setType()
     * @uses AddressObjectView::setCountryGuid()
     * @uses AddressObjectView::setHasStreets()
     * @param string $name
     * @param string $englishName
     * @param string $view
     * @param string $regionCode
     * @param string $type
     * @param string $countryGuid
     * @param bool $hasStreets
     */
    public function __construct($name = null, $englishName = null, $view = null, $regionCode = null, $type = null, $countryGuid = null, $hasStreets = null)
    {
        $this
            ->setName($name)
            ->setEnglishName($englishName)
            ->setView($view)
            ->setRegionCode($regionCode)
            ->setType($type)
            ->setCountryGuid($countryGuid)
            ->setHasStreets($hasStreets);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\AddressObjectView
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get englishName value
     * @return string|null
     */
    public function getEnglishName()
    {
        return $this->englishName;
    }
    /**
     * Set englishName value
     * @param string $englishName
     * @return \StructType\AddressObjectView
     */
    public function setEnglishName($englishName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($englishName) && strlen($englishName) > 255) || (is_array($englishName) && count($englishName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($englishName) ? strlen($englishName) : count($englishName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($englishName) && !is_string($englishName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($englishName)), __LINE__);
        }
        $this->englishName = $englishName;
        return $this;
    }
    /**
     * Get view value
     * @return string|null
     */
    public function getView()
    {
        return $this->view;
    }
    /**
     * Set view value
     * @param string $view
     * @return \StructType\AddressObjectView
     */
    public function setView($view = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($view) && strlen($view) > 255) || (is_array($view) && count($view) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($view) ? strlen($view) : count($view)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($view) && !is_string($view)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($view)), __LINE__);
        }
        $this->view = $view;
        return $this;
    }
    /**
     * Get regionCode value
     * @return string|null
     */
    public function getRegionCode()
    {
        return $this->regionCode;
    }
    /**
     * Set regionCode value
     * @param string $regionCode
     * @return \StructType\AddressObjectView
     */
    public function setRegionCode($regionCode = null)
    {
        // validation for constraint: string
        if (!is_null($regionCode) && !is_string($regionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regionCode)), __LINE__);
        }
        $this->regionCode = $regionCode;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @param string $type
     * @return \StructType\AddressObjectView
     */
    public function setType($type = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($type) && strlen($type) > 255) || (is_array($type) && count($type) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($type) ? strlen($type) : count($type)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($type)), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get countryGuid value
     * @return string|null
     */
    public function getCountryGuid()
    {
        return $this->countryGuid;
    }
    /**
     * Set countryGuid value
     * @param string $countryGuid
     * @return \StructType\AddressObjectView
     */
    public function setCountryGuid($countryGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($countryGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $countryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($countryGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($countryGuid) && !is_string($countryGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($countryGuid)), __LINE__);
        }
        $this->countryGuid = $countryGuid;
        return $this;
    }
    /**
     * Get hasStreets value
     * @return bool|null
     */
    public function getHasStreets()
    {
        return $this->hasStreets;
    }
    /**
     * Set hasStreets value
     * @param bool $hasStreets
     * @return \StructType\AddressObjectView
     */
    public function setHasStreets($hasStreets = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasStreets) && !is_bool($hasStreets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($hasStreets)), __LINE__);
        }
        $this->hasStreets = $hasStreets;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddressObjectView
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
