<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBusinessEntityUserResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ответ на регистрацию/привязку пользователя(ей) хозяйствующего субъекта. Ответ содержит список пользователей, для которых в
 * результате запроса была выполнена регистрация/привязка. | Сведения о зарегистрированном/привязанном пользователе.
 * @subpackage Structs
 */
class AddBusinessEntityUserResponse extends ApplicationResultData
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - ref: vd:user
     * @var \StructType\User[]
     */
    public $user;
    /**
     * Constructor method for AddBusinessEntityUserResponse
     * @uses AddBusinessEntityUserResponse::setUser()
     * @param \StructType\User[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\User[]|null
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $user
     * @return \StructType\AddBusinessEntityUserResponse
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $addBusinessEntityUserResponseUserItem) {
            // validation for constraint: itemType
            if (!$addBusinessEntityUserResponseUserItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($addBusinessEntityUserResponseUserItem) ? get_class($addBusinessEntityUserResponseUserItem) : gettype($addBusinessEntityUserResponseUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\AddBusinessEntityUserResponse
     */
    public function addToUser(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddBusinessEntityUserResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
