<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddBusinessEntityUserRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос на регистрацию/привязку пользователя(ей) хозяйствующего субъекта. Если пользователь с указанным uuid, login, passport или snils уже
 * зарегистрирован и ФИО совпадает, он будет прикреплен к ХС-заявителю (если зарегистрированный пользователь не привязан к ХС-заявителю).
 * Профиль пользователя при этом обновлен не будет. Если ФИО не совпадает или пользователь уже привязан к ХС-заявителю -- пользователь
 * зарегистрирован/привязан не будет. Иначе регистрируется новый пользователь при условии заполнения обязательных сведений. За один
 * запрос можно зарегистрировать/привязать не более N пользователей. Для вновь регистрируемых пользователей и существующих
 * пользователей, для которых выполняется привязка к ХС-заявителю, будут установлены права и зоны ответственности, указанные в запросе. |
 * Сведения о регистрируемом пользователе.
 * @subpackage Structs
 */
class AddBusinessEntityUserRequest extends MercuryApplicationRequest
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: vd:user
     * @var \StructType\User[]
     */
    public $user;
    /**
     * Constructor method for AddBusinessEntityUserRequest
     * @uses AddBusinessEntityUserRequest::setUser()
     * @param \StructType\User[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\User[]
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $user
     * @return \StructType\AddBusinessEntityUserRequest
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $addBusinessEntityUserRequestUserItem) {
            // validation for constraint: itemType
            if (!$addBusinessEntityUserRequestUserItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($addBusinessEntityUserRequestUserItem) ? get_class($addBusinessEntityUserRequestUserItem) : gettype($addBusinessEntityUserRequestUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\AddBusinessEntityUserRequest
     */
    public function addToUser(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddBusinessEntityUserRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
