<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for activityLocation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Место осуществления деятельности. | Список предприятий, для которых должна измениться привязка к хозяйствующему субъекту.
 * @subpackage Structs
 */
class ActivityLocation extends AbstractStructBase
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The globalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - documentation: Тип для представления Global Location Number.
     * - length: 13
     * @var string[]
     */
    public $globalID;
    /**
     * Constructor method for activityLocation
     * @uses ActivityLocation::setEnterprise()
     * @uses ActivityLocation::setGlobalID()
     * @param \StructType\Enterprise $enterprise
     * @param string[] $globalID
     */
    public function __construct(\StructType\Enterprise $enterprise = null, array $globalID = array())
    {
        $this
            ->setEnterprise($enterprise)
            ->setGlobalID($globalID);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\ActivityLocation
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get globalID value
     * @return string[]|null
     */
    public function getGlobalID()
    {
        return $this->globalID;
    }
    /**
     * Set globalID value
     * @throws \InvalidArgumentException
     * @param string[] $globalID
     * @return \StructType\ActivityLocation
     */
    public function setGlobalID(array $globalID = array())
    {
        // validation for constraint: length
        if ((is_scalar($globalID) && strlen($globalID) !== 13) || (is_array($globalID) && count($globalID) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        foreach ($globalID as $activityLocationGlobalIDItem) {
            // validation for constraint: itemType
            if (!is_string($activityLocationGlobalIDItem)) {
                throw new \InvalidArgumentException(sprintf('The globalID property can only contain items of string, "%s" given', is_object($activityLocationGlobalIDItem) ? get_class($activityLocationGlobalIDItem) : gettype($activityLocationGlobalIDItem)), __LINE__);
            }
        }
        $this->globalID = $globalID;
        return $this;
    }
    /**
     * Add item to globalID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ActivityLocation
     */
    public function addToGlobalID($item)
    {
        // validation for constraint: length
        if ((is_scalar($item) && strlen($item) !== 13) || (is_array($item) && count($item) !== 13)) {
            throw new \InvalidArgumentException('Invalid length, please provide an array with 13 element(s) or a scalar of 13 character(s)', __LINE__);
        }
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The globalID property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->globalID[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ActivityLocation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
