<?php

namespace EnumType;

/**
 * This class stands for VeterinaryEventType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип мероприятия
 * @subpackage Enumerations
 */
class VeterinaryEventType
{
    /**
     * Constant for value 'UND'
     * @return string 'UND'
     */
    const VALUE_UND = 'UND';
    /**
     * Constant for value 'LBR'
     * @return string 'LBR'
     */
    const VALUE_LBR = 'LBR';
    /**
     * Constant for value 'VSE'
     * @return string 'VSE'
     */
    const VALUE_VSE = 'VSE';
    /**
     * Constant for value 'IMM'
     * @return string 'IMM'
     */
    const VALUE_IMM = 'IMM';
    /**
     * Constant for value 'MED'
     * @return string 'MED'
     */
    const VALUE_MED = 'MED';
    /**
     * Constant for value 'QRT'
     * @return string 'QRT'
     */
    const VALUE_QRT = 'QRT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UND
     * @uses self::VALUE_LBR
     * @uses self::VALUE_VSE
     * @uses self::VALUE_IMM
     * @uses self::VALUE_MED
     * @uses self::VALUE_QRT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UND,
            self::VALUE_LBR,
            self::VALUE_VSE,
            self::VALUE_IMM,
            self::VALUE_MED,
            self::VALUE_QRT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
