<?php

namespace EnumType;

/**
 * This class stands for VetDocumentForm EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий форму ВСД.
 * @subpackage Enumerations
 */
class VetDocumentForm
{
    /**
     * Constant for value 'CERTCU1'
     * @return string 'CERTCU1'
     */
    const VALUE_CERTCU_1 = 'CERTCU1';
    /**
     * Constant for value 'LIC1'
     * @return string 'LIC1'
     */
    const VALUE_LIC_1 = 'LIC1';
    /**
     * Constant for value 'CERTCU2'
     * @return string 'CERTCU2'
     */
    const VALUE_CERTCU_2 = 'CERTCU2';
    /**
     * Constant for value 'LIC2'
     * @return string 'LIC2'
     */
    const VALUE_LIC_2 = 'LIC2';
    /**
     * Constant for value 'CERTCU3'
     * @return string 'CERTCU3'
     */
    const VALUE_CERTCU_3 = 'CERTCU3';
    /**
     * Constant for value 'LIC3'
     * @return string 'LIC3'
     */
    const VALUE_LIC_3 = 'LIC3';
    /**
     * Constant for value 'NOTE4'
     * @return string 'NOTE4'
     */
    const VALUE_NOTE_4 = 'NOTE4';
    /**
     * Constant for value 'CERT5I'
     * @return string 'CERT5I'
     */
    const VALUE_CERT_5_I = 'CERT5I';
    /**
     * Constant for value 'CERT61'
     * @return string 'CERT61'
     */
    const VALUE_CERT_61 = 'CERT61';
    /**
     * Constant for value 'CERT62'
     * @return string 'CERT62'
     */
    const VALUE_CERT_62 = 'CERT62';
    /**
     * Constant for value 'CERT63'
     * @return string 'CERT63'
     */
    const VALUE_CERT_63 = 'CERT63';
    /**
     * Constant for value 'PRODUCTIVE'
     * @return string 'PRODUCTIVE'
     */
    const VALUE_PRODUCTIVE = 'PRODUCTIVE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CERTCU_1
     * @uses self::VALUE_LIC_1
     * @uses self::VALUE_CERTCU_2
     * @uses self::VALUE_LIC_2
     * @uses self::VALUE_CERTCU_3
     * @uses self::VALUE_LIC_3
     * @uses self::VALUE_NOTE_4
     * @uses self::VALUE_CERT_5_I
     * @uses self::VALUE_CERT_61
     * @uses self::VALUE_CERT_62
     * @uses self::VALUE_CERT_63
     * @uses self::VALUE_PRODUCTIVE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CERTCU_1,
            self::VALUE_LIC_1,
            self::VALUE_CERTCU_2,
            self::VALUE_LIC_2,
            self::VALUE_CERTCU_3,
            self::VALUE_LIC_3,
            self::VALUE_NOTE_4,
            self::VALUE_CERT_5_I,
            self::VALUE_CERT_61,
            self::VALUE_CERT_62,
            self::VALUE_CERT_63,
            self::VALUE_PRODUCTIVE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
