<?php

namespace EnumType;

/**
 * This class stands for TransportationStorageType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Способ хранения при перевозке.
 * @subpackage Enumerations
 */
class TransportationStorageType
{
    /**
     * Constant for value 'FROZEN'
     * @return string 'FROZEN'
     */
    const VALUE_FROZEN = 'FROZEN';
    /**
     * Constant for value 'CHILLED'
     * @return string 'CHILLED'
     */
    const VALUE_CHILLED = 'CHILLED';
    /**
     * Constant for value 'COOLED'
     * @return string 'COOLED'
     */
    const VALUE_COOLED = 'COOLED';
    /**
     * Constant for value 'VENTILATED'
     * @return string 'VENTILATED'
     */
    const VALUE_VENTILATED = 'VENTILATED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_FROZEN
     * @uses self::VALUE_CHILLED
     * @uses self::VALUE_COOLED
     * @uses self::VALUE_VENTILATED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_FROZEN,
            self::VALUE_CHILLED,
            self::VALUE_COOLED,
            self::VALUE_VENTILATED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
