<?php

namespace EnumType;

/**
 * This class stands for RegisterModificationType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Тип операции на изменение реестра.
 * @subpackage Enumerations
 */
class RegisterModificationType
{
    /**
     * Constant for value 'CREATE'
     * @return string 'CREATE'
     */
    const VALUE_CREATE = 'CREATE';
    /**
     * Constant for value 'FIND_OR_CREATE'
     * @return string 'FIND_OR_CREATE'
     */
    const VALUE_FIND_OR_CREATE = 'FIND_OR_CREATE';
    /**
     * Constant for value 'UPDATE'
     * @return string 'UPDATE'
     */
    const VALUE_UPDATE = 'UPDATE';
    /**
     * Constant for value 'DELETE'
     * @return string 'DELETE'
     */
    const VALUE_DELETE = 'DELETE';
    /**
     * Constant for value 'MERGE'
     * @return string 'MERGE'
     */
    const VALUE_MERGE = 'MERGE';
    /**
     * Constant for value 'ATTACH'
     * @return string 'ATTACH'
     */
    const VALUE_ATTACH = 'ATTACH';
    /**
     * Constant for value 'SPLIT'
     * @return string 'SPLIT'
     */
    const VALUE_SPLIT = 'SPLIT';
    /**
     * Constant for value 'FORK'
     * @return string 'FORK'
     */
    const VALUE_FORK = 'FORK';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREATE
     * @uses self::VALUE_FIND_OR_CREATE
     * @uses self::VALUE_UPDATE
     * @uses self::VALUE_DELETE
     * @uses self::VALUE_MERGE
     * @uses self::VALUE_ATTACH
     * @uses self::VALUE_SPLIT
     * @uses self::VALUE_FORK
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREATE,
            self::VALUE_FIND_OR_CREATE,
            self::VALUE_UPDATE,
            self::VALUE_DELETE,
            self::VALUE_MERGE,
            self::VALUE_ATTACH,
            self::VALUE_SPLIT,
            self::VALUE_FORK,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
