<?php

namespace EnumType;

/**
 * This class stands for ProsperityType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Статус благополучия
 * @subpackage Enumerations
 */
class ProsperityType
{
    /**
     * Constant for value 'UNDEFINED'
     * @return string 'UNDEFINED'
     */
    const VALUE_UNDEFINED = 'UNDEFINED';
    /**
     * Constant for value 'UNKNOWN'
     * @return string 'UNKNOWN'
     */
    const VALUE_UNKNOWN = 'UNKNOWN';
    /**
     * Constant for value 'SAFE'
     * @return string 'SAFE'
     */
    const VALUE_SAFE = 'SAFE';
    /**
     * Constant for value 'UNSAFE'
     * @return string 'UNSAFE'
     */
    const VALUE_UNSAFE = 'UNSAFE';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_SAFE
     * @uses self::VALUE_UNSAFE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_UNKNOWN,
            self::VALUE_SAFE,
            self::VALUE_UNSAFE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
