<?php

namespace EnumType;

/**
 * This class stands for NonFoodProductSourceType EnumType
 * @subpackage Enumerations
 */
class NonFoodProductSourceType
{
    /**
     * Constant for value 'CATTLE_SLAUGHTER'
     * @return string 'CATTLE_SLAUGHTER'
     */
    const VALUE_CATTLE_SLAUGHTER = 'CATTLE_SLAUGHTER';
    /**
     * Constant for value 'LOSS_OF_CATTLE'
     * @return string 'LOSS_OF_CATTLE'
     */
    const VALUE_LOSS_OF_CATTLE = 'LOSS_OF_CATTLE';
    /**
     * Constant for value 'MANUFACTURED'
     * @return string 'MANUFACTURED'
     */
    const VALUE_MANUFACTURED = 'MANUFACTURED';
    /**
     * Constant for value 'MIXED'
     * @return string 'MIXED'
     */
    const VALUE_MIXED = 'MIXED';
    /**
     * Constant for value 'FROM_HEALTHY_ANIMALS'
     * @return string 'FROM_HEALTHY_ANIMALS'
     */
    const VALUE_FROM_HEALTHY_ANIMALS = 'FROM_HEALTHY_ANIMALS';
    /**
     * Constant for value 'FROM_SICK_ANIMALS'
     * @return string 'FROM_SICK_ANIMALS'
     */
    const VALUE_FROM_SICK_ANIMALS = 'FROM_SICK_ANIMALS';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CATTLE_SLAUGHTER
     * @uses self::VALUE_LOSS_OF_CATTLE
     * @uses self::VALUE_MANUFACTURED
     * @uses self::VALUE_MIXED
     * @uses self::VALUE_FROM_HEALTHY_ANIMALS
     * @uses self::VALUE_FROM_SICK_ANIMALS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CATTLE_SLAUGHTER,
            self::VALUE_LOSS_OF_CATTLE,
            self::VALUE_MANUFACTURED,
            self::VALUE_MIXED,
            self::VALUE_FROM_HEALTHY_ANIMALS,
            self::VALUE_FROM_SICK_ANIMALS,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
