<?php

namespace EnumType;

/**
 * This class stands for DeliveryInspectionResult EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Результат контроля поставки
 * @subpackage Enumerations
 */
class DeliveryInspectionResult
{
    /**
     * Constant for value 'CORRESPONDS'
     * @return string 'CORRESPONDS'
     */
    const VALUE_CORRESPONDS = 'CORRESPONDS';
    /**
     * Constant for value 'MISMATCH'
     * @return string 'MISMATCH'
     */
    const VALUE_MISMATCH = 'MISMATCH';
    /**
     * Constant for value 'UNSUPERVISED'
     * @return string 'UNSUPERVISED'
     */
    const VALUE_UNSUPERVISED = 'UNSUPERVISED';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CORRESPONDS
     * @uses self::VALUE_MISMATCH
     * @uses self::VALUE_UNSUPERVISED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CORRESPONDS,
            self::VALUE_MISMATCH,
            self::VALUE_UNSUPERVISED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
