<?php

namespace EnumType;

/**
 * This class stands for DeliveryDecision EnumType
 * Meta informations extracted from the WSDL
 * - documentation: Решение по поставке.
 * @subpackage Enumerations
 */
class DeliveryDecision
{
    /**
     * Constant for value 'ACCEPT_ALL'
     * @return string 'ACCEPT_ALL'
     */
    const VALUE_ACCEPT_ALL = 'ACCEPT_ALL';
    /**
     * Constant for value 'PARTIALLY'
     * @return string 'PARTIALLY'
     */
    const VALUE_PARTIALLY = 'PARTIALLY';
    /**
     * Constant for value 'RETURN_ALL'
     * @return string 'RETURN_ALL'
     */
    const VALUE_RETURN_ALL = 'RETURN_ALL';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ACCEPT_ALL
     * @uses self::VALUE_PARTIALLY
     * @uses self::VALUE_RETURN_ALL
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ACCEPT_ALL,
            self::VALUE_PARTIALLY,
            self::VALUE_RETURN_ALL,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
