<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WorkingAreaList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список зон обслуживания.
 * @subpackage Structs
 */
class WorkingAreaList extends EntityList
{
    /**
     * The workingArea
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\WorkingArea[]
     */
    public $workingArea;
    /**
     * Constructor method for WorkingAreaList
     * @uses WorkingAreaList::setWorkingArea()
     * @param \StructType\WorkingArea[] $workingArea
     */
    public function __construct(array $workingArea = array())
    {
        $this
            ->setWorkingArea($workingArea);
    }
    /**
     * Get workingArea value
     * @return \StructType\WorkingArea[]|null
     */
    public function getWorkingArea()
    {
        return $this->workingArea;
    }
    /**
     * Set workingArea value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkingArea[] $workingArea
     * @return \StructType\WorkingAreaList
     */
    public function setWorkingArea(array $workingArea = array())
    {
        foreach ($workingArea as $workingAreaListWorkingAreaItem) {
            // validation for constraint: itemType
            if (!$workingAreaListWorkingAreaItem instanceof \StructType\WorkingArea) {
                throw new \InvalidArgumentException(sprintf('The workingArea property can only contain items of \StructType\WorkingArea, "%s" given', is_object($workingAreaListWorkingAreaItem) ? get_class($workingAreaListWorkingAreaItem) : gettype($workingAreaListWorkingAreaItem)), __LINE__);
            }
        }
        $this->workingArea = $workingArea;
        return $this;
    }
    /**
     * Add item to workingArea value
     * @throws \InvalidArgumentException
     * @param \StructType\WorkingArea $item
     * @return \StructType\WorkingAreaList
     */
    public function addToWorkingArea(\StructType\WorkingArea $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WorkingArea) {
            throw new \InvalidArgumentException(sprintf('The workingArea property can only contain items of \StructType\WorkingArea, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->workingArea[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WorkingAreaList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
