<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VetDocumentStatusChange StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения об изменении статуса ветеринарного документа
 * @subpackage Structs
 */
class VetDocumentStatusChange extends AbstractStructBase
{
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Установленный статус документа.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $status;
    /**
     * The specifiedPerson
     * Meta informations extracted from the WSDL
     * - documentation: Пользователь, изменивший статус ВСД (например, подписавший или аннулировавший его).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\User
     */
    public $specifiedPerson;
    /**
     * The actualDateTime
     * Meta informations extracted from the WSDL
     * - documentation: Дата и время изменения статуса ВСД.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $actualDateTime;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Основание изменения статуса ВСД (например, причина аннулирования сертификата). | Основание изменения статуса ВСД | Строковый
     * тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * Constructor method for VetDocumentStatusChange
     * @uses VetDocumentStatusChange::setStatus()
     * @uses VetDocumentStatusChange::setSpecifiedPerson()
     * @uses VetDocumentStatusChange::setActualDateTime()
     * @uses VetDocumentStatusChange::setReason()
     * @param string $status
     * @param \StructType\User $specifiedPerson
     * @param string $actualDateTime
     * @param string $reason
     */
    public function __construct($status = null, \StructType\User $specifiedPerson = null, $actualDateTime = null, $reason = null)
    {
        $this
            ->setStatus($status)
            ->setSpecifiedPerson($specifiedPerson)
            ->setActualDateTime($actualDateTime)
            ->setReason($reason);
    }
    /**
     * Get status value
     * @return string
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @uses \EnumType\VetDocumentStatus::valueIsValid()
     * @uses \EnumType\VetDocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\VetDocumentStatusChange
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\VetDocumentStatus::getValidValues())), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get specifiedPerson value
     * @return \StructType\User
     */
    public function getSpecifiedPerson()
    {
        return $this->specifiedPerson;
    }
    /**
     * Set specifiedPerson value
     * @param \StructType\User $specifiedPerson
     * @return \StructType\VetDocumentStatusChange
     */
    public function setSpecifiedPerson(\StructType\User $specifiedPerson = null)
    {
        $this->specifiedPerson = $specifiedPerson;
        return $this;
    }
    /**
     * Get actualDateTime value
     * @return string
     */
    public function getActualDateTime()
    {
        return $this->actualDateTime;
    }
    /**
     * Set actualDateTime value
     * @param string $actualDateTime
     * @return \StructType\VetDocumentStatusChange
     */
    public function setActualDateTime($actualDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDateTime) && !is_string($actualDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($actualDateTime)), __LINE__);
        }
        $this->actualDateTime = $actualDateTime;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\VetDocumentStatusChange
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VetDocumentStatusChange
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
