<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateVeterinaryEventsRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на внесение сведений о ветеринарных мероприятиях с партией продукции таких, как лабораторные исследования,
 * карантинирование, иммунизации и обработки для живых животных. Поддерживается обновление сведений о лабораторных исследованиях, для
 * которых ранее не был указан результат исследования. | Запись складского журнала, для которой вносятся/обновляются сведения о
 * мероприятиях. Может быть указано более одной записи складского журнала. Для каждой записи должен быть указан идентификатор (GUID) и список
 * мероприятий stockEntry/vetEventList. При обновлении результатов лабораторных исследований у соответствующего stockEntry/vetEventList/laboratoryResearch должен быть
 * указан идентификатор ID.
 * @subpackage Structs
 */
class UpdateVeterinaryEventsRequest extends MercuryApplicationRequest
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: vd:stockEntry
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * Constructor method for UpdateVeterinaryEventsRequest
     * @uses UpdateVeterinaryEventsRequest::setEnterprise()
     * @uses UpdateVeterinaryEventsRequest::setStockEntry()
     * @param \StructType\Enterprise $enterprise
     * @param \StructType\StockEntry[] $stockEntry
     */
    public function __construct(\StructType\Enterprise $enterprise = null, array $stockEntry = array())
    {
        $this
            ->setEnterprise($enterprise)
            ->setStockEntry($stockEntry);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\UpdateVeterinaryEventsRequest
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\UpdateVeterinaryEventsRequest
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $updateVeterinaryEventsRequestStockEntryItem) {
            // validation for constraint: itemType
            if (!$updateVeterinaryEventsRequestStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($updateVeterinaryEventsRequestStockEntryItem) ? get_class($updateVeterinaryEventsRequestStockEntryItem) : gettype($updateVeterinaryEventsRequestStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\UpdateVeterinaryEventsRequest
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateVeterinaryEventsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
