<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UpdateUserWorkingAreasRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Запрос на изменение зон ответственности пользователя | Пользователь, для которого изменяются права доступа. Должен быть
 * указан `uuid` или `login`. Изменяются поля: `workingAreaList` -- зоны ответственности пользователя
 * @subpackage Structs
 */
class UpdateUserWorkingAreasRequest extends MercuryApplicationRequest
{
    /**
     * The user
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * - ref: vd:user
     * @var \StructType\User[]
     */
    public $user;
    /**
     * Constructor method for UpdateUserWorkingAreasRequest
     * @uses UpdateUserWorkingAreasRequest::setUser()
     * @param \StructType\User[] $user
     */
    public function __construct(array $user = array())
    {
        $this
            ->setUser($user);
    }
    /**
     * Get user value
     * @return \StructType\User[]
     */
    public function getUser()
    {
        return $this->user;
    }
    /**
     * Set user value
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $user
     * @return \StructType\UpdateUserWorkingAreasRequest
     */
    public function setUser(array $user = array())
    {
        foreach ($user as $updateUserWorkingAreasRequestUserItem) {
            // validation for constraint: itemType
            if (!$updateUserWorkingAreasRequestUserItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($updateUserWorkingAreasRequestUserItem) ? get_class($updateUserWorkingAreasRequestUserItem) : gettype($updateUserWorkingAreasRequestUserItem)), __LINE__);
            }
        }
        $this->user = $user;
        return $this;
    }
    /**
     * Add item to user value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\UpdateUserWorkingAreasRequest
     */
    public function addToUser(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The user property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->user[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UpdateUserWorkingAreasRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
