<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnitList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список единиц измерений.
 * @subpackage Structs
 */
class UnitList extends EntityList
{
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Unit[]
     */
    public $unit;
    /**
     * Constructor method for UnitList
     * @uses UnitList::setUnit()
     * @param \StructType\Unit[] $unit
     */
    public function __construct(array $unit = array())
    {
        $this
            ->setUnit($unit);
    }
    /**
     * Get unit value
     * @return \StructType\Unit[]|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit[] $unit
     * @return \StructType\UnitList
     */
    public function setUnit(array $unit = array())
    {
        foreach ($unit as $unitListUnitItem) {
            // validation for constraint: itemType
            if (!$unitListUnitItem instanceof \StructType\Unit) {
                throw new \InvalidArgumentException(sprintf('The unit property can only contain items of \StructType\Unit, "%s" given', is_object($unitListUnitItem) ? get_class($unitListUnitItem) : gettype($unitListUnitItem)), __LINE__);
            }
        }
        $this->unit = $unit;
        return $this;
    }
    /**
     * Add item to unit value
     * @throws \InvalidArgumentException
     * @param \StructType\Unit $item
     * @return \StructType\UnitList
     */
    public function addToUnit(\StructType\Unit $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Unit) {
            throw new \InvalidArgumentException(sprintf('The unit property can only contain items of \StructType\Unit, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->unit[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnitList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
