<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for submitApplicationRequest StructType
 * @subpackage Structs
 */
class SubmitApplicationRequest extends AbstractStructBase
{
    /**
     * The apiKey
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $apiKey;
    /**
     * The application
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: apl:application
     * @var \StructType\Application
     */
    public $application;
    /**
     * Constructor method for submitApplicationRequest
     * @uses SubmitApplicationRequest::setApiKey()
     * @uses SubmitApplicationRequest::setApplication()
     * @param string $apiKey
     * @param \StructType\Application $application
     */
    public function __construct($apiKey = null, \StructType\Application $application = null)
    {
        $this
            ->setApiKey($apiKey)
            ->setApplication($application);
    }
    /**
     * Get apiKey value
     * @return string
     */
    public function getApiKey()
    {
        return $this->apiKey;
    }
    /**
     * Set apiKey value
     * @param string $apiKey
     * @return \StructType\SubmitApplicationRequest
     */
    public function setApiKey($apiKey = null)
    {
        // validation for constraint: string
        if (!is_null($apiKey) && !is_string($apiKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($apiKey)), __LINE__);
        }
        $this->apiKey = $apiKey;
        return $this;
    }
    /**
     * Get application value
     * @return \StructType\Application
     */
    public function getApplication()
    {
        return $this->application;
    }
    /**
     * Set application value
     * @param \StructType\Application $application
     * @return \StructType\SubmitApplicationRequest
     */
    public function setApplication(\StructType\Application $application = null)
    {
        $this->application = $application;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubmitApplicationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
