<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubProductList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список видов продукции.
 * @subpackage Structs
 */
class SubProductList extends EntityList
{
    /**
     * The subProduct
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubProduct[]
     */
    public $subProduct;
    /**
     * Constructor method for SubProductList
     * @uses SubProductList::setSubProduct()
     * @param \StructType\SubProduct[] $subProduct
     */
    public function __construct(array $subProduct = array())
    {
        $this
            ->setSubProduct($subProduct);
    }
    /**
     * Get subProduct value
     * @return \StructType\SubProduct[]|null
     */
    public function getSubProduct()
    {
        return $this->subProduct;
    }
    /**
     * Set subProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct[] $subProduct
     * @return \StructType\SubProductList
     */
    public function setSubProduct(array $subProduct = array())
    {
        foreach ($subProduct as $subProductListSubProductItem) {
            // validation for constraint: itemType
            if (!$subProductListSubProductItem instanceof \StructType\SubProduct) {
                throw new \InvalidArgumentException(sprintf('The subProduct property can only contain items of \StructType\SubProduct, "%s" given', is_object($subProductListSubProductItem) ? get_class($subProductListSubProductItem) : gettype($subProductListSubProductItem)), __LINE__);
            }
        }
        $this->subProduct = $subProduct;
        return $this;
    }
    /**
     * Add item to subProduct value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct $item
     * @return \StructType\SubProductList
     */
    public function addToSubProduct(\StructType\SubProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubProduct) {
            throw new \InvalidArgumentException(sprintf('The subProduct property can only contain items of \StructType\SubProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->subProduct[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubProductList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
