<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubProduct StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий вид продукции.
 * @subpackage Structs
 */
class SubProduct extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Код ТНВЭД. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $code;
    /**
     * The englishName
     * Meta informations extracted from the WSDL
     * - documentation: Английское название. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $englishName;
    /**
     * The productGuid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор продукции, которому относится данный вид продукции. | Тип, описывающий уникальный идентификатор
     * любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $productGuid;
    /**
     * Constructor method for SubProduct
     * @uses SubProduct::setName()
     * @uses SubProduct::setCode()
     * @uses SubProduct::setEnglishName()
     * @uses SubProduct::setProductGuid()
     * @param string $name
     * @param string $code
     * @param string $englishName
     * @param string $productGuid
     */
    public function __construct($name = null, $code = null, $englishName = null, $productGuid = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setEnglishName($englishName)
            ->setProductGuid($productGuid);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\SubProduct
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\SubProduct
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 255) || (is_array($code) && count($code) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get englishName value
     * @return string|null
     */
    public function getEnglishName()
    {
        return $this->englishName;
    }
    /**
     * Set englishName value
     * @param string $englishName
     * @return \StructType\SubProduct
     */
    public function setEnglishName($englishName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($englishName) && strlen($englishName) > 255) || (is_array($englishName) && count($englishName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($englishName) ? strlen($englishName) : count($englishName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($englishName) && !is_string($englishName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($englishName)), __LINE__);
        }
        $this->englishName = $englishName;
        return $this;
    }
    /**
     * Get productGuid value
     * @return string|null
     */
    public function getProductGuid()
    {
        return $this->productGuid;
    }
    /**
     * Set productGuid value
     * @param string $productGuid
     * @return \StructType\SubProduct
     */
    public function setProductGuid($productGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($productGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $productGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($productGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($productGuid) && !is_string($productGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($productGuid)), __LINE__);
        }
        $this->productGuid = $productGuid;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SubProduct
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
