<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StreetList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип-обертка для списка улиц.
 * @subpackage Structs
 */
class StreetList extends EntityList
{
    /**
     * The street
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Street[]
     */
    public $street;
    /**
     * Constructor method for StreetList
     * @uses StreetList::setStreet()
     * @param \StructType\Street[] $street
     */
    public function __construct(array $street = array())
    {
        $this
            ->setStreet($street);
    }
    /**
     * Get street value
     * @return \StructType\Street[]|null
     */
    public function getStreet()
    {
        return $this->street;
    }
    /**
     * Set street value
     * @throws \InvalidArgumentException
     * @param \StructType\Street[] $street
     * @return \StructType\StreetList
     */
    public function setStreet(array $street = array())
    {
        foreach ($street as $streetListStreetItem) {
            // validation for constraint: itemType
            if (!$streetListStreetItem instanceof \StructType\Street) {
                throw new \InvalidArgumentException(sprintf('The street property can only contain items of \StructType\Street, "%s" given', is_object($streetListStreetItem) ? get_class($streetListStreetItem) : gettype($streetListStreetItem)), __LINE__);
            }
        }
        $this->street = $street;
        return $this;
    }
    /**
     * Add item to street value
     * @throws \InvalidArgumentException
     * @param \StructType\Street $item
     * @return \StructType\StreetList
     */
    public function addToStreet(\StructType\Street $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Street) {
            throw new \InvalidArgumentException(sprintf('The street property can only contain items of \StructType\Street, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->street[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StreetList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
