<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockEntrySearchPattern StructType
 * @subpackage Structs
 */
class StockEntrySearchPattern extends StockEntry
{
    /**
     * The blankFilter
     * Meta informations extracted from the WSDL
     * - documentation: Фильтр по объёму записи складского журнала. Значение по умолчанию -- ALL. См. тип StockEntryBlankFilter.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $blankFilter;
    /**
     * The receiptDateInterval
     * Meta informations extracted from the WSDL
     * - documentation: Интервал даты поступления партии на склад (дата создания первой версии stockEntry).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DateInterval
     */
    public $receiptDateInterval;
    /**
     * Constructor method for StockEntrySearchPattern
     * @uses StockEntrySearchPattern::setBlankFilter()
     * @uses StockEntrySearchPattern::setReceiptDateInterval()
     * @param string $blankFilter
     * @param \StructType\DateInterval $receiptDateInterval
     */
    public function __construct($blankFilter = null, \StructType\DateInterval $receiptDateInterval = null)
    {
        $this
            ->setBlankFilter($blankFilter)
            ->setReceiptDateInterval($receiptDateInterval);
    }
    /**
     * Get blankFilter value
     * @return string|null
     */
    public function getBlankFilter()
    {
        return $this->blankFilter;
    }
    /**
     * Set blankFilter value
     * @uses \EnumType\StockEntryBlankFilter::valueIsValid()
     * @uses \EnumType\StockEntryBlankFilter::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $blankFilter
     * @return \StructType\StockEntrySearchPattern
     */
    public function setBlankFilter($blankFilter = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\StockEntryBlankFilter::valueIsValid($blankFilter)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $blankFilter, implode(', ', \EnumType\StockEntryBlankFilter::getValidValues())), __LINE__);
        }
        $this->blankFilter = $blankFilter;
        return $this;
    }
    /**
     * Get receiptDateInterval value
     * @return \StructType\DateInterval|null
     */
    public function getReceiptDateInterval()
    {
        return $this->receiptDateInterval;
    }
    /**
     * Set receiptDateInterval value
     * @param \StructType\DateInterval $receiptDateInterval
     * @return \StructType\StockEntrySearchPattern
     */
    public function setReceiptDateInterval(\StructType\DateInterval $receiptDateInterval = null)
    {
        $this->receiptDateInterval = $receiptDateInterval;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockEntrySearchPattern
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
