<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockEntryList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список записей журнала.
 * @subpackage Structs
 */
class StockEntryList extends EntityList
{
    /**
     * The stockEntry
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $stockEntry;
    /**
     * Constructor method for StockEntryList
     * @uses StockEntryList::setStockEntry()
     * @param \StructType\StockEntry[] $stockEntry
     */
    public function __construct(array $stockEntry = array())
    {
        $this
            ->setStockEntry($stockEntry);
    }
    /**
     * Get stockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getStockEntry()
    {
        return $this->stockEntry;
    }
    /**
     * Set stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $stockEntry
     * @return \StructType\StockEntryList
     */
    public function setStockEntry(array $stockEntry = array())
    {
        foreach ($stockEntry as $stockEntryListStockEntryItem) {
            // validation for constraint: itemType
            if (!$stockEntryListStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($stockEntryListStockEntryItem) ? get_class($stockEntryListStockEntryItem) : gettype($stockEntryListStockEntryItem)), __LINE__);
            }
        }
        $this->stockEntry = $stockEntry;
        return $this;
    }
    /**
     * Add item to stockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\StockEntryList
     */
    public function addToStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The stockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->stockEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockEntryList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
