<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StockDiscrepancy StructType
 * Meta informations extracted from the WSDL
 * - documentation: Операция внесения изменений в реестр предприятий.
 * @subpackage Structs
 */
class StockDiscrepancy extends AbstractStructBase
{
    /**
     * The affectedList
     * Meta informations extracted from the WSDL
     * - documentation: Входящие записи для операции. Deprecated.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntryList
     */
    public $affectedList;
    /**
     * The resultingList
     * Meta informations extracted from the WSDL
     * - documentation: Получаемые в результате операции записи.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntryList
     */
    public $resultingList;
    /**
     * The reason
     * Meta informations extracted from the WSDL
     * - documentation: Причина несоответствия.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reason;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор, определяющий stockDiscrepancy в запросе. Должен быть указан, если запрос содержит несколько элементов stockDiscrepancy.
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * Constructor method for StockDiscrepancy
     * @uses StockDiscrepancy::setAffectedList()
     * @uses StockDiscrepancy::setResultingList()
     * @uses StockDiscrepancy::setReason()
     * @uses StockDiscrepancy::setId()
     * @param \StructType\StockEntryList $affectedList
     * @param \StructType\StockEntryList $resultingList
     * @param string $reason
     * @param string $id
     */
    public function __construct(\StructType\StockEntryList $affectedList = null, \StructType\StockEntryList $resultingList = null, $reason = null, $id = null)
    {
        $this
            ->setAffectedList($affectedList)
            ->setResultingList($resultingList)
            ->setReason($reason)
            ->setId($id);
    }
    /**
     * Get affectedList value
     * @return \StructType\StockEntryList|null
     */
    public function getAffectedList()
    {
        return $this->affectedList;
    }
    /**
     * Set affectedList value
     * @param \StructType\StockEntryList $affectedList
     * @return \StructType\StockDiscrepancy
     */
    public function setAffectedList(\StructType\StockEntryList $affectedList = null)
    {
        $this->affectedList = $affectedList;
        return $this;
    }
    /**
     * Get resultingList value
     * @return \StructType\StockEntryList|null
     */
    public function getResultingList()
    {
        return $this->resultingList;
    }
    /**
     * Set resultingList value
     * @param \StructType\StockEntryList $resultingList
     * @return \StructType\StockDiscrepancy
     */
    public function setResultingList(\StructType\StockEntryList $resultingList = null)
    {
        $this->resultingList = $resultingList;
        return $this;
    }
    /**
     * Get reason value
     * @return string|null
     */
    public function getReason()
    {
        return $this->reason;
    }
    /**
     * Set reason value
     * @param string $reason
     * @return \StructType\StockDiscrepancy
     */
    public function setReason($reason = null)
    {
        // validation for constraint: string
        if (!is_null($reason) && !is_string($reason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($reason)), __LINE__);
        }
        $this->reason = $reason;
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\StockDiscrepancy
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\StockDiscrepancy
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
