<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResolveDiscrepancyResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на регистрацию несоответствий в записях складского журнала, выявленных в результате инвентаризации.
 * @subpackage Structs
 */
class ResolveDiscrepancyResponse extends ApplicationResultData
{
    /**
     * The stockEntryList
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о созданных и/или измененных версиях записей журнала продукции.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\StockEntryList
     */
    public $stockEntryList;
    /**
     * Constructor method for ResolveDiscrepancyResponse
     * @uses ResolveDiscrepancyResponse::setStockEntryList()
     * @param \StructType\StockEntryList $stockEntryList
     */
    public function __construct(\StructType\StockEntryList $stockEntryList = null)
    {
        $this
            ->setStockEntryList($stockEntryList);
    }
    /**
     * Get stockEntryList value
     * @return \StructType\StockEntryList
     */
    public function getStockEntryList()
    {
        return $this->stockEntryList;
    }
    /**
     * Set stockEntryList value
     * @param \StructType\StockEntryList $stockEntryList
     * @return \StructType\ResolveDiscrepancyResponse
     */
    public function setStockEntryList(\StructType\StockEntryList $stockEntryList = null)
    {
        $this->stockEntryList = $stockEntryList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResolveDiscrepancyResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
