<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResearchMethodList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список методов исследований.
 * @subpackage Structs
 */
class ResearchMethodList extends EntityList
{
    /**
     * The method
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResearchMethod[]
     */
    public $method;
    /**
     * Constructor method for ResearchMethodList
     * @uses ResearchMethodList::setMethod()
     * @param \StructType\ResearchMethod[] $method
     */
    public function __construct(array $method = array())
    {
        $this
            ->setMethod($method);
    }
    /**
     * Get method value
     * @return \StructType\ResearchMethod[]|null
     */
    public function getMethod()
    {
        return $this->method;
    }
    /**
     * Set method value
     * @throws \InvalidArgumentException
     * @param \StructType\ResearchMethod[] $method
     * @return \StructType\ResearchMethodList
     */
    public function setMethod(array $method = array())
    {
        foreach ($method as $researchMethodListMethodItem) {
            // validation for constraint: itemType
            if (!$researchMethodListMethodItem instanceof \StructType\ResearchMethod) {
                throw new \InvalidArgumentException(sprintf('The method property can only contain items of \StructType\ResearchMethod, "%s" given', is_object($researchMethodListMethodItem) ? get_class($researchMethodListMethodItem) : gettype($researchMethodListMethodItem)), __LINE__);
            }
        }
        $this->method = $method;
        return $this;
    }
    /**
     * Add item to method value
     * @throws \InvalidArgumentException
     * @param \StructType\ResearchMethod $item
     * @return \StructType\ResearchMethodList
     */
    public function addToMethod(\StructType\ResearchMethod $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResearchMethod) {
            throw new \InvalidArgumentException(sprintf('The method property can only contain items of \StructType\ResearchMethod, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->method[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResearchMethodList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
