<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegisterProductionOperationResponse StructType
 * Meta informations extracted from the WSDL
 * - documentation: Результат заявки на оформление производственной партии.
 * @subpackage Structs
 */
class RegisterProductionOperationResponse extends ApplicationResultData
{
    /**
     * The stockEntryList
     * Meta informations extracted from the WSDL
     * - documentation: Сведения о созданных и/или измененных записях журнала продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntryList
     */
    public $stockEntryList;
    /**
     * The vetDocument
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об оформленном или погашенном ветеринарном сертификате.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VetDocument[]
     */
    public $vetDocument;
    /**
     * Constructor method for RegisterProductionOperationResponse
     * @uses RegisterProductionOperationResponse::setStockEntryList()
     * @uses RegisterProductionOperationResponse::setVetDocument()
     * @param \StructType\StockEntryList $stockEntryList
     * @param \StructType\VetDocument[] $vetDocument
     */
    public function __construct(\StructType\StockEntryList $stockEntryList = null, array $vetDocument = array())
    {
        $this
            ->setStockEntryList($stockEntryList)
            ->setVetDocument($vetDocument);
    }
    /**
     * Get stockEntryList value
     * @return \StructType\StockEntryList|null
     */
    public function getStockEntryList()
    {
        return $this->stockEntryList;
    }
    /**
     * Set stockEntryList value
     * @param \StructType\StockEntryList $stockEntryList
     * @return \StructType\RegisterProductionOperationResponse
     */
    public function setStockEntryList(\StructType\StockEntryList $stockEntryList = null)
    {
        $this->stockEntryList = $stockEntryList;
        return $this;
    }
    /**
     * Get vetDocument value
     * @return \StructType\VetDocument[]|null
     */
    public function getVetDocument()
    {
        return $this->vetDocument;
    }
    /**
     * Set vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument[] $vetDocument
     * @return \StructType\RegisterProductionOperationResponse
     */
    public function setVetDocument(array $vetDocument = array())
    {
        foreach ($vetDocument as $registerProductionOperationResponseVetDocumentItem) {
            // validation for constraint: itemType
            if (!$registerProductionOperationResponseVetDocumentItem instanceof \StructType\VetDocument) {
                throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($registerProductionOperationResponseVetDocumentItem) ? get_class($registerProductionOperationResponseVetDocumentItem) : gettype($registerProductionOperationResponseVetDocumentItem)), __LINE__);
            }
        }
        $this->vetDocument = $vetDocument;
        return $this;
    }
    /**
     * Add item to vetDocument value
     * @throws \InvalidArgumentException
     * @param \StructType\VetDocument $item
     * @return \StructType\RegisterProductionOperationResponse
     */
    public function addToVetDocument(\StructType\VetDocument $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VetDocument) {
            throw new \InvalidArgumentException(sprintf('The vetDocument property can only contain items of \StructType\VetDocument, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->vetDocument[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegisterProductionOperationResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
