<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationStatus StructType
 * Meta informations extracted from the WSDL
 * - documentation: Статус региона в соответствии с регионализацией
 * @subpackage Structs
 */
class RegionalizationStatus extends AbstractStructBase
{
    /**
     * The relatedDisease
     * Meta informations extracted from the WSDL
     * - documentation: Заболевание, по которому назначен статус
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AnimalDisease
     */
    public $relatedDisease;
    /**
     * The prosperity
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $prosperity;
    /**
     * The vaccination
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $vaccination;
    /**
     * Constructor method for RegionalizationStatus
     * @uses RegionalizationStatus::setRelatedDisease()
     * @uses RegionalizationStatus::setProsperity()
     * @uses RegionalizationStatus::setVaccination()
     * @param \StructType\AnimalDisease $relatedDisease
     * @param string $prosperity
     * @param string $vaccination
     */
    public function __construct(\StructType\AnimalDisease $relatedDisease = null, $prosperity = null, $vaccination = null)
    {
        $this
            ->setRelatedDisease($relatedDisease)
            ->setProsperity($prosperity)
            ->setVaccination($vaccination);
    }
    /**
     * Get relatedDisease value
     * @return \StructType\AnimalDisease
     */
    public function getRelatedDisease()
    {
        return $this->relatedDisease;
    }
    /**
     * Set relatedDisease value
     * @param \StructType\AnimalDisease $relatedDisease
     * @return \StructType\RegionalizationStatus
     */
    public function setRelatedDisease(\StructType\AnimalDisease $relatedDisease = null)
    {
        $this->relatedDisease = $relatedDisease;
        return $this;
    }
    /**
     * Get prosperity value
     * @return string
     */
    public function getProsperity()
    {
        return $this->prosperity;
    }
    /**
     * Set prosperity value
     * @uses \EnumType\ProsperityType::valueIsValid()
     * @uses \EnumType\ProsperityType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $prosperity
     * @return \StructType\RegionalizationStatus
     */
    public function setProsperity($prosperity = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProsperityType::valueIsValid($prosperity)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $prosperity, implode(', ', \EnumType\ProsperityType::getValidValues())), __LINE__);
        }
        $this->prosperity = $prosperity;
        return $this;
    }
    /**
     * Get vaccination value
     * @return string
     */
    public function getVaccination()
    {
        return $this->vaccination;
    }
    /**
     * Set vaccination value
     * @uses \EnumType\VaccinationType::valueIsValid()
     * @uses \EnumType\VaccinationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vaccination
     * @return \StructType\RegionalizationStatus
     */
    public function setVaccination($vaccination = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VaccinationType::valueIsValid($vaccination)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vaccination, implode(', ', \EnumType\VaccinationType::getValidValues())), __LINE__);
        }
        $this->vaccination = $vaccination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
