<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationShippingRuleList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список правил перемещения (регионализация).
 * @subpackage Structs
 */
class RegionalizationShippingRuleList extends EntityList
{
    /**
     * The rule
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationShippingRule[]
     */
    public $rule;
    /**
     * Constructor method for RegionalizationShippingRuleList
     * @uses RegionalizationShippingRuleList::setRule()
     * @param \StructType\RegionalizationShippingRule[] $rule
     */
    public function __construct(array $rule = array())
    {
        $this
            ->setRule($rule);
    }
    /**
     * Get rule value
     * @return \StructType\RegionalizationShippingRule[]|null
     */
    public function getRule()
    {
        return $this->rule;
    }
    /**
     * Set rule value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationShippingRule[] $rule
     * @return \StructType\RegionalizationShippingRuleList
     */
    public function setRule(array $rule = array())
    {
        foreach ($rule as $regionalizationShippingRuleListRuleItem) {
            // validation for constraint: itemType
            if (!$regionalizationShippingRuleListRuleItem instanceof \StructType\RegionalizationShippingRule) {
                throw new \InvalidArgumentException(sprintf('The rule property can only contain items of \StructType\RegionalizationShippingRule, "%s" given', is_object($regionalizationShippingRuleListRuleItem) ? get_class($regionalizationShippingRuleListRuleItem) : gettype($regionalizationShippingRuleListRuleItem)), __LINE__);
            }
        }
        $this->rule = $rule;
        return $this;
    }
    /**
     * Add item to rule value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationShippingRule $item
     * @return \StructType\RegionalizationShippingRuleList
     */
    public function addToRule(\StructType\RegionalizationShippingRule $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationShippingRule) {
            throw new \InvalidArgumentException(sprintf('The rule property can only contain items of \StructType\RegionalizationShippingRule, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->rule[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationShippingRuleList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
