<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationShippingRule StructType
 * Meta informations extracted from the WSDL
 * - documentation: Правило перемещения партии согласно регионализации
 * @subpackage Structs
 */
class RegionalizationShippingRule extends GenericVersioningEntity
{
    /**
     * The referenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер правила перевозки в реестре. | Тип, описывающий идентификатор.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $referenceNumber;
    /**
     * The fromR13nStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус территории, откуда партия отправляется (место отправления), согласно регионализации.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegionalizationStatus
     */
    public $fromR13nStatus;
    /**
     * The toR13nStatus
     * Meta informations extracted from the WSDL
     * - documentation: Статус территории, куда партия направляется (место назначения), согласно регионализации.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\RegionalizationStatus
     */
    public $toR13nStatus;
    /**
     * The cargoType
     * Meta informations extracted from the WSDL
     * - documentation: Ветеринарная категория груза, на которую распространяется правило перемещения.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SubProduct[]
     */
    public $cargoType;
    /**
     * The decision
     * Meta informations extracted from the WSDL
     * - documentation: Решение о возможности перемещения груза: перемещение запрещено, перемещение разрешено или перемещение разрешено при
     * обязательном соблюдении условий.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $decision;
    /**
     * The requirement
     * Meta informations extracted from the WSDL
     * - documentation: Требование к перемещению партии в отношении к определенному заболеванию.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\RegionalizationRequirement[]
     */
    public $requirement;
    /**
     * Constructor method for RegionalizationShippingRule
     * @uses RegionalizationShippingRule::setReferenceNumber()
     * @uses RegionalizationShippingRule::setFromR13nStatus()
     * @uses RegionalizationShippingRule::setToR13nStatus()
     * @uses RegionalizationShippingRule::setCargoType()
     * @uses RegionalizationShippingRule::setDecision()
     * @uses RegionalizationShippingRule::setRequirement()
     * @param string $referenceNumber
     * @param \StructType\RegionalizationStatus $fromR13nStatus
     * @param \StructType\RegionalizationStatus $toR13nStatus
     * @param \StructType\SubProduct[] $cargoType
     * @param string $decision
     * @param \StructType\RegionalizationRequirement[] $requirement
     */
    public function __construct($referenceNumber = null, \StructType\RegionalizationStatus $fromR13nStatus = null, \StructType\RegionalizationStatus $toR13nStatus = null, array $cargoType = array(), $decision = null, array $requirement = array())
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setFromR13nStatus($fromR13nStatus)
            ->setToR13nStatus($toR13nStatus)
            ->setCargoType($cargoType)
            ->setDecision($decision)
            ->setRequirement($requirement);
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\RegionalizationShippingRule
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceNumber) && strlen($referenceNumber) > 100) || (is_array($referenceNumber) && count($referenceNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($referenceNumber) ? strlen($referenceNumber) : count($referenceNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get fromR13nStatus value
     * @return \StructType\RegionalizationStatus|null
     */
    public function getFromR13nStatus()
    {
        return $this->fromR13nStatus;
    }
    /**
     * Set fromR13nStatus value
     * @param \StructType\RegionalizationStatus $fromR13nStatus
     * @return \StructType\RegionalizationShippingRule
     */
    public function setFromR13nStatus(\StructType\RegionalizationStatus $fromR13nStatus = null)
    {
        $this->fromR13nStatus = $fromR13nStatus;
        return $this;
    }
    /**
     * Get toR13nStatus value
     * @return \StructType\RegionalizationStatus|null
     */
    public function getToR13nStatus()
    {
        return $this->toR13nStatus;
    }
    /**
     * Set toR13nStatus value
     * @param \StructType\RegionalizationStatus $toR13nStatus
     * @return \StructType\RegionalizationShippingRule
     */
    public function setToR13nStatus(\StructType\RegionalizationStatus $toR13nStatus = null)
    {
        $this->toR13nStatus = $toR13nStatus;
        return $this;
    }
    /**
     * Get cargoType value
     * @return \StructType\SubProduct[]|null
     */
    public function getCargoType()
    {
        return $this->cargoType;
    }
    /**
     * Set cargoType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct[] $cargoType
     * @return \StructType\RegionalizationShippingRule
     */
    public function setCargoType(array $cargoType = array())
    {
        foreach ($cargoType as $regionalizationShippingRuleCargoTypeItem) {
            // validation for constraint: itemType
            if (!$regionalizationShippingRuleCargoTypeItem instanceof \StructType\SubProduct) {
                throw new \InvalidArgumentException(sprintf('The cargoType property can only contain items of \StructType\SubProduct, "%s" given', is_object($regionalizationShippingRuleCargoTypeItem) ? get_class($regionalizationShippingRuleCargoTypeItem) : gettype($regionalizationShippingRuleCargoTypeItem)), __LINE__);
            }
        }
        $this->cargoType = $cargoType;
        return $this;
    }
    /**
     * Add item to cargoType value
     * @throws \InvalidArgumentException
     * @param \StructType\SubProduct $item
     * @return \StructType\RegionalizationShippingRule
     */
    public function addToCargoType(\StructType\SubProduct $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SubProduct) {
            throw new \InvalidArgumentException(sprintf('The cargoType property can only contain items of \StructType\SubProduct, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->cargoType[] = $item;
        return $this;
    }
    /**
     * Get decision value
     * @return string|null
     */
    public function getDecision()
    {
        return $this->decision;
    }
    /**
     * Set decision value
     * @uses \EnumType\RegionalizationDecision::valueIsValid()
     * @uses \EnumType\RegionalizationDecision::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $decision
     * @return \StructType\RegionalizationShippingRule
     */
    public function setDecision($decision = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegionalizationDecision::valueIsValid($decision)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $decision, implode(', ', \EnumType\RegionalizationDecision::getValidValues())), __LINE__);
        }
        $this->decision = $decision;
        return $this;
    }
    /**
     * Get requirement value
     * @return \StructType\RegionalizationRequirement[]|null
     */
    public function getRequirement()
    {
        return $this->requirement;
    }
    /**
     * Set requirement value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationRequirement[] $requirement
     * @return \StructType\RegionalizationShippingRule
     */
    public function setRequirement(array $requirement = array())
    {
        foreach ($requirement as $regionalizationShippingRuleRequirementItem) {
            // validation for constraint: itemType
            if (!$regionalizationShippingRuleRequirementItem instanceof \StructType\RegionalizationRequirement) {
                throw new \InvalidArgumentException(sprintf('The requirement property can only contain items of \StructType\RegionalizationRequirement, "%s" given', is_object($regionalizationShippingRuleRequirementItem) ? get_class($regionalizationShippingRuleRequirementItem) : gettype($regionalizationShippingRuleRequirementItem)), __LINE__);
            }
        }
        $this->requirement = $requirement;
        return $this;
    }
    /**
     * Add item to requirement value
     * @throws \InvalidArgumentException
     * @param \StructType\RegionalizationRequirement $item
     * @return \StructType\RegionalizationShippingRule
     */
    public function addToRequirement(\StructType\RegionalizationRequirement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\RegionalizationRequirement) {
            throw new \InvalidArgumentException(sprintf('The requirement property can only contain items of \StructType\RegionalizationRequirement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->requirement[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationShippingRule
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
