<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RegionalizationCondition StructType
 * Meta informations extracted from the WSDL
 * - documentation: Условие регионализации, соблюдаемое при перевозке груза
 * @subpackage Structs
 */
class RegionalizationCondition extends GenericVersioningEntity
{
    /**
     * The referenceNumber
     * Meta informations extracted from the WSDL
     * - documentation: Номер условия | Тип, описывающий идентификатор.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 100
     * @var string
     */
    public $referenceNumber;
    /**
     * The text
     * Meta informations extracted from the WSDL
     * - documentation: Формулировка условия | Строковый тип без ограничения максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $text;
    /**
     * The strict
     * Meta informations extracted from the WSDL
     * - documentation: Обязательность соблюдения условия
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $strict;
    /**
     * The relatedDisease
     * Meta informations extracted from the WSDL
     * - documentation: Заболевание, к которому относится данное условие
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AnimalDisease[]
     */
    public $relatedDisease;
    /**
     * Constructor method for RegionalizationCondition
     * @uses RegionalizationCondition::setReferenceNumber()
     * @uses RegionalizationCondition::setText()
     * @uses RegionalizationCondition::setStrict()
     * @uses RegionalizationCondition::setRelatedDisease()
     * @param string $referenceNumber
     * @param string $text
     * @param bool $strict
     * @param \StructType\AnimalDisease[] $relatedDisease
     */
    public function __construct($referenceNumber = null, $text = null, $strict = null, array $relatedDisease = array())
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setText($text)
            ->setStrict($strict)
            ->setRelatedDisease($relatedDisease);
    }
    /**
     * Get referenceNumber value
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->referenceNumber;
    }
    /**
     * Set referenceNumber value
     * @param string $referenceNumber
     * @return \StructType\RegionalizationCondition
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($referenceNumber) && strlen($referenceNumber) > 100) || (is_array($referenceNumber) && count($referenceNumber) > 100)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 100 element(s) or a scalar of 100 character(s) at most, "%d" length given', is_scalar($referenceNumber) ? strlen($referenceNumber) : count($referenceNumber)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenceNumber)), __LINE__);
        }
        $this->referenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get text value
     * @return string|null
     */
    public function getText()
    {
        return $this->text;
    }
    /**
     * Set text value
     * @param string $text
     * @return \StructType\RegionalizationCondition
     */
    public function setText($text = null)
    {
        // validation for constraint: string
        if (!is_null($text) && !is_string($text)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($text)), __LINE__);
        }
        $this->text = $text;
        return $this;
    }
    /**
     * Get strict value
     * @return bool|null
     */
    public function getStrict()
    {
        return $this->strict;
    }
    /**
     * Set strict value
     * @param bool $strict
     * @return \StructType\RegionalizationCondition
     */
    public function setStrict($strict = null)
    {
        // validation for constraint: boolean
        if (!is_null($strict) && !is_bool($strict)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($strict)), __LINE__);
        }
        $this->strict = $strict;
        return $this;
    }
    /**
     * Get relatedDisease value
     * @return \StructType\AnimalDisease[]|null
     */
    public function getRelatedDisease()
    {
        return $this->relatedDisease;
    }
    /**
     * Set relatedDisease value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalDisease[] $relatedDisease
     * @return \StructType\RegionalizationCondition
     */
    public function setRelatedDisease(array $relatedDisease = array())
    {
        foreach ($relatedDisease as $regionalizationConditionRelatedDiseaseItem) {
            // validation for constraint: itemType
            if (!$regionalizationConditionRelatedDiseaseItem instanceof \StructType\AnimalDisease) {
                throw new \InvalidArgumentException(sprintf('The relatedDisease property can only contain items of \StructType\AnimalDisease, "%s" given', is_object($regionalizationConditionRelatedDiseaseItem) ? get_class($regionalizationConditionRelatedDiseaseItem) : gettype($regionalizationConditionRelatedDiseaseItem)), __LINE__);
            }
        }
        $this->relatedDisease = $relatedDisease;
        return $this;
    }
    /**
     * Add item to relatedDisease value
     * @throws \InvalidArgumentException
     * @param \StructType\AnimalDisease $item
     * @return \StructType\RegionalizationCondition
     */
    public function addToRelatedDisease(\StructType\AnimalDisease $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AnimalDisease) {
            throw new \InvalidArgumentException(sprintf('The relatedDisease property can only contain items of \StructType\AnimalDisease, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->relatedDisease[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RegionalizationCondition
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
