<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferencedDocument StructType
 * Meta informations extracted from the WSDL
 * - documentation: Сведения о связанном документе.
 * @subpackage Structs
 */
class ReferencedDocument extends Document
{
    /**
     * The relationshipType
     * Meta informations extracted from the WSDL
     * - documentation: Тип отношения между документами.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $relationshipType;
    /**
     * Constructor method for ReferencedDocument
     * @uses ReferencedDocument::setRelationshipType()
     * @param string $relationshipType
     */
    public function __construct($relationshipType = null)
    {
        $this
            ->setRelationshipType($relationshipType);
    }
    /**
     * Get relationshipType value
     * @return string
     */
    public function getRelationshipType()
    {
        return $this->relationshipType;
    }
    /**
     * Set relationshipType value
     * @uses \EnumType\ReferenceType::valueIsValid()
     * @uses \EnumType\ReferenceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $relationshipType
     * @return \StructType\ReferencedDocument
     */
    public function setRelationshipType($relationshipType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReferenceType::valueIsValid($relationshipType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $relationshipType, implode(', ', \EnumType\ReferenceType::getValidValues())), __LINE__);
        }
        $this->relationshipType = $relationshipType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferencedDocument
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
