<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RawBatch StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий сырьё для производственной партии.
 * @subpackage Structs
 */
class RawBatch extends AbstractStructBase
{
    /**
     * The sourceStockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Запись журнала, которая используется в качестве сырья. Должен быть указан обязательно. В случае, если сырьё указывается для
     * незавершенной производственной транзакции, следующие поля (volume, unit, packingList, packingAmount) могут быть не заполнены до окончательного
     * завершения транзакции (см. ProductionOperation/finalizeOperation), если отсутствует возможность точно определить использованный объём в момент выпуска
     * партии продукции. Таким образом, в ещё не закрытом производственном сертификате уже будет указано использованное сырьё без указания
     * конкретного объёма, т.е. реализована прослеживаемость.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\StockEntry
     */
    public $sourceStockEntry;
    /**
     * The volume
     * Meta informations extracted from the WSDL
     * - documentation: Объём сырья. | Вещественный тип с ограничением числа знаков после запятой.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - fractionDigits: 6
     * @var float
     */
    public $volume;
    /**
     * The unit
     * Meta informations extracted from the WSDL
     * - documentation: Единица измерения объёма груза.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Unit
     */
    public $unit;
    /**
     * The packageList
     * Meta informations extracted from the WSDL
     * - documentation: Описание физической упаковки партии продукции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PackageList
     */
    public $packageList;
    /**
     * Constructor method for RawBatch
     * @uses RawBatch::setSourceStockEntry()
     * @uses RawBatch::setVolume()
     * @uses RawBatch::setUnit()
     * @uses RawBatch::setPackageList()
     * @param \StructType\StockEntry $sourceStockEntry
     * @param float $volume
     * @param \StructType\Unit $unit
     * @param \StructType\PackageList $packageList
     */
    public function __construct(\StructType\StockEntry $sourceStockEntry = null, $volume = null, \StructType\Unit $unit = null, \StructType\PackageList $packageList = null)
    {
        $this
            ->setSourceStockEntry($sourceStockEntry)
            ->setVolume($volume)
            ->setUnit($unit)
            ->setPackageList($packageList);
    }
    /**
     * Get sourceStockEntry value
     * @return \StructType\StockEntry|null
     */
    public function getSourceStockEntry()
    {
        return $this->sourceStockEntry;
    }
    /**
     * Set sourceStockEntry value
     * @param \StructType\StockEntry $sourceStockEntry
     * @return \StructType\RawBatch
     */
    public function setSourceStockEntry(\StructType\StockEntry $sourceStockEntry = null)
    {
        $this->sourceStockEntry = $sourceStockEntry;
        return $this;
    }
    /**
     * Get volume value
     * @return float|null
     */
    public function getVolume()
    {
        return $this->volume;
    }
    /**
     * Set volume value
     * @param float $volume
     * @return \StructType\RawBatch
     */
    public function setVolume($volume = null)
    {
        // validation for constraint: fractionDigits
        if (is_float($volume) && strlen(substr($volume, strpos($volume, '.') + 1)) !== 6) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must at most contain 6 fraction digits, "%d" given', strlen(substr($volume, strpos($volume, '.') + 1))), __LINE__);
        }
        $this->volume = $volume;
        return $this;
    }
    /**
     * Get unit value
     * @return \StructType\Unit|null
     */
    public function getUnit()
    {
        return $this->unit;
    }
    /**
     * Set unit value
     * @param \StructType\Unit $unit
     * @return \StructType\RawBatch
     */
    public function setUnit(\StructType\Unit $unit = null)
    {
        $this->unit = $unit;
        return $this;
    }
    /**
     * Get packageList value
     * @return \StructType\PackageList|null
     */
    public function getPackageList()
    {
        return $this->packageList;
    }
    /**
     * Set packageList value
     * @param \StructType\PackageList $packageList
     * @return \StructType\RawBatch
     */
    public function setPackageList(\StructType\PackageList $packageList = null)
    {
        $this->packageList = $packageList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RawBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
