<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurposeList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий список целей.
 * @subpackage Structs
 */
class PurposeList extends EntityList
{
    /**
     * The purpose
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Purpose[]
     */
    public $purpose;
    /**
     * Constructor method for PurposeList
     * @uses PurposeList::setPurpose()
     * @param \StructType\Purpose[] $purpose
     */
    public function __construct(array $purpose = array())
    {
        $this
            ->setPurpose($purpose);
    }
    /**
     * Get purpose value
     * @return \StructType\Purpose[]|null
     */
    public function getPurpose()
    {
        return $this->purpose;
    }
    /**
     * Set purpose value
     * @throws \InvalidArgumentException
     * @param \StructType\Purpose[] $purpose
     * @return \StructType\PurposeList
     */
    public function setPurpose(array $purpose = array())
    {
        foreach ($purpose as $purposeListPurposeItem) {
            // validation for constraint: itemType
            if (!$purposeListPurposeItem instanceof \StructType\Purpose) {
                throw new \InvalidArgumentException(sprintf('The purpose property can only contain items of \StructType\Purpose, "%s" given', is_object($purposeListPurposeItem) ? get_class($purposeListPurposeItem) : gettype($purposeListPurposeItem)), __LINE__);
            }
        }
        $this->purpose = $purpose;
        return $this;
    }
    /**
     * Add item to purpose value
     * @throws \InvalidArgumentException
     * @param \StructType\Purpose $item
     * @return \StructType\PurposeList
     */
    public function addToPurpose(\StructType\Purpose $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Purpose) {
            throw new \InvalidArgumentException(sprintf('The purpose property can only contain items of \StructType\Purpose, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->purpose[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PurposeList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
