<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductiveBatch StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий транспортную партию груза. При оформлении незавершенного производства важно: если очередной запрос
 * RegisterProductionOperationRequest содержит сведения о выработанной продукции с указанным номером партии (Batch/batchID)), и ранее в рамках этой же
 * производственной транзакции уже была оформлена выработанная продукция с тем же номером партии, то вновь выработанный объём продукции
 * будет оприходован на ту же запись складского журнала с увеличением её объёма (т.е. будет выполнено автоматическое присоединение записей
 * журнала, guid записи журнала останется прежним).
 * @subpackage Structs
 */
class ProductiveBatch extends Batch
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор, определяющий batch в запросе. Должен быть указан, если запрос содержит несколько элементов batch. Если в запросе
     * указано более одной производственной партии, то сведения для оформления ВСД (элемент vetDocument) могут совпадать для этих производственных
     * партий или отличаться. Если сведения совпадаются, то в запросе указывается единственный элемент vetDocument, иначе указывается несколько, по
     * одному на каждый элемент productiveBatch. При этом значение атрибута for элемента vetDocument совпадает со значением атрибута id соответствующего
     * элемента productiveBatch.
     * - use: optional
     * @var string
     */
    public $id;
    /**
     * Constructor method for ProductiveBatch
     * @uses ProductiveBatch::setId()
     * @param string $id
     */
    public function __construct($id = null)
    {
        $this
            ->setId($id);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\ProductiveBatch
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ProductiveBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
