<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Product StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий продукцию.
 * @subpackage Structs
 */
class Product extends GenericVersioningEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - documentation: Название. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - documentation: Код ТНВЭД. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $code;
    /**
     * The englishName
     * Meta informations extracted from the WSDL
     * - documentation: Английское название. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $englishName;
    /**
     * The productType
     * Meta informations extracted from the WSDL
     * - documentation: Тип продукции, которому относится данная продукция.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $productType;
    /**
     * Constructor method for Product
     * @uses Product::setName()
     * @uses Product::setCode()
     * @uses Product::setEnglishName()
     * @uses Product::setProductType()
     * @param string $name
     * @param string $code
     * @param string $englishName
     * @param string $productType
     */
    public function __construct($name = null, $code = null, $englishName = null, $productType = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setEnglishName($englishName)
            ->setProductType($productType);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Product
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\Product
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 255) || (is_array($code) && count($code) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get englishName value
     * @return string|null
     */
    public function getEnglishName()
    {
        return $this->englishName;
    }
    /**
     * Set englishName value
     * @param string $englishName
     * @return \StructType\Product
     */
    public function setEnglishName($englishName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($englishName) && strlen($englishName) > 255) || (is_array($englishName) && count($englishName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($englishName) ? strlen($englishName) : count($englishName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($englishName) && !is_string($englishName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($englishName)), __LINE__);
        }
        $this->englishName = $englishName;
        return $this;
    }
    /**
     * Get productType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->productType;
    }
    /**
     * Set productType value
     * @uses \EnumType\ProductType::valueIsValid()
     * @uses \EnumType\ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\Product
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\ProductType::getValidValues())), __LINE__);
        }
        $this->productType = $productType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Product
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
