<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Producer StructType
 * Meta informations extracted from the WSDL
 * - documentation: Производитель продукции
 * @subpackage Structs
 */
class Producer extends AbstractStructBase
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The role
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $role;
    /**
     * Constructor method for Producer
     * @uses Producer::setEnterprise()
     * @uses Producer::setRole()
     * @param \StructType\Enterprise $enterprise
     * @param string $role
     */
    public function __construct(\StructType\Enterprise $enterprise = null, $role = null)
    {
        $this
            ->setEnterprise($enterprise)
            ->setRole($role);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\Producer
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get role value
     * @return string|null
     */
    public function getRole()
    {
        return $this->role;
    }
    /**
     * Set role value
     * @uses \EnumType\EnterpriseRole::valueIsValid()
     * @uses \EnumType\EnterpriseRole::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $role
     * @return \StructType\Producer
     */
    public function setRole($role = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnterpriseRole::valueIsValid($role)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $role, implode(', ', \EnumType\EnterpriseRole::getValidValues())), __LINE__);
        }
        $this->role = $role;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Producer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
