<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareOutgoingConsignmentRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на оформление транспортной партии.
 * @subpackage Structs
 */
class PrepareOutgoingConsignmentRequest extends MercuryApplicationRequest
{
    /**
     * The delivery
     * Meta informations extracted from the WSDL
     * - documentation: Сведения об отгрузке.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\Delivery[]
     */
    public $delivery;
    /**
     * Constructor method for PrepareOutgoingConsignmentRequest
     * @uses PrepareOutgoingConsignmentRequest::setDelivery()
     * @param \StructType\Delivery[] $delivery
     */
    public function __construct(array $delivery = array())
    {
        $this
            ->setDelivery($delivery);
    }
    /**
     * Get delivery value
     * @return \StructType\Delivery[]
     */
    public function getDelivery()
    {
        return $this->delivery;
    }
    /**
     * Set delivery value
     * @throws \InvalidArgumentException
     * @param \StructType\Delivery[] $delivery
     * @return \StructType\PrepareOutgoingConsignmentRequest
     */
    public function setDelivery(array $delivery = array())
    {
        foreach ($delivery as $prepareOutgoingConsignmentRequestDeliveryItem) {
            // validation for constraint: itemType
            if (!$prepareOutgoingConsignmentRequestDeliveryItem instanceof \StructType\Delivery) {
                throw new \InvalidArgumentException(sprintf('The delivery property can only contain items of \StructType\Delivery, "%s" given', is_object($prepareOutgoingConsignmentRequestDeliveryItem) ? get_class($prepareOutgoingConsignmentRequestDeliveryItem) : gettype($prepareOutgoingConsignmentRequestDeliveryItem)), __LINE__);
            }
        }
        $this->delivery = $delivery;
        return $this;
    }
    /**
     * Add item to delivery value
     * @throws \InvalidArgumentException
     * @param \StructType\Delivery $item
     * @return \StructType\PrepareOutgoingConsignmentRequest
     */
    public function addToDelivery(\StructType\Delivery $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Delivery) {
            throw new \InvalidArgumentException(sprintf('The delivery property can only contain items of \StructType\Delivery, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->delivery[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PrepareOutgoingConsignmentRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
