<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PackageList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Список физической упаковки
 * @subpackage Structs
 */
class PackageList extends AbstractStructBase
{
    /**
     * The package
     * Meta informations extracted from the WSDL
     * - documentation: Описание упаковки
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Package[]
     */
    public $package;
    /**
     * Constructor method for PackageList
     * @uses PackageList::setPackage()
     * @param \StructType\Package[] $package
     */
    public function __construct(array $package = array())
    {
        $this
            ->setPackage($package);
    }
    /**
     * Get package value
     * @return \StructType\Package[]|null
     */
    public function getPackage()
    {
        return $this->package;
    }
    /**
     * Set package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package[] $package
     * @return \StructType\PackageList
     */
    public function setPackage(array $package = array())
    {
        foreach ($package as $packageListPackageItem) {
            // validation for constraint: itemType
            if (!$packageListPackageItem instanceof \StructType\Package) {
                throw new \InvalidArgumentException(sprintf('The package property can only contain items of \StructType\Package, "%s" given', is_object($packageListPackageItem) ? get_class($packageListPackageItem) : gettype($packageListPackageItem)), __LINE__);
            }
        }
        $this->package = $package;
        return $this;
    }
    /**
     * Add item to package value
     * @throws \InvalidArgumentException
     * @param \StructType\Package $item
     * @return \StructType\PackageList
     */
    public function addToPackage(\StructType\Package $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Package) {
            throw new \InvalidArgumentException(sprintf('The package property can only contain items of \StructType\Package, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->package[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PackageList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
