<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Package StructType
 * Meta informations extracted from the WSDL
 * - documentation: Упаковка партии продукции. | Поддерживается указание многоуровневой упаковки и маркировки партии продукции. Всего
 * предусмотрено шесть уровней упаковки (см. тип dt:PackageLevelType). Количество единиц упаковки и маркировка партии указывается для каждой
 * упаковки конкретного уровня отдельно. На каждом уровне может быть произвольное количество типов упаковки, в том числе и ни одного, т.е.
 * какого-то уровня упаковки в описании партии продукции может не быть. Если уровень упаковки однозначно определить не получается,
 * например, груз перевозится в потребительской упаковке, т.е. эта упаковка в то же время может считаться и транспортной, то рекомендуется
 * указывать наименьший уровень, т.е. для примера выше, упаковка будет отнесена к потребительскому уровню. Уровнь и тип упаковки
 * обязательны для указания. Количество единиц упаковки может быть не указано. В то же время, для корректного оформления ветеринарного
 * сертификата, рекомендуется указывать количество единиц упаковки, в которой перевозится продукция. Важно, что количество мест в
 * транспортной партии будет определено как сумма всех упаковок на последнем/максимальном уровне, который указан в описании партии.
 * Примеры описания упаковки для различных типов продукции и вариантов перевозки представлены в справочной системе.
 * @subpackage Structs
 */
class Package extends AbstractStructBase
{
    /**
     * The level
     * Meta informations extracted from the WSDL
     * - documentation: Уровень упаковки
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $level;
    /**
     * The packingType
     * Meta informations extracted from the WSDL
     * - documentation: Тип упаковки
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PackingType
     */
    public $packingType;
    /**
     * The quantity
     * Meta informations extracted from the WSDL
     * - documentation: Количество единиц упаковки.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $quantity;
    /**
     * The productMarks
     * Meta informations extracted from the WSDL
     * - documentation: Маркировка партии продукции
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProductMarks[]
     */
    public $productMarks;
    /**
     * Constructor method for Package
     * @uses Package::setLevel()
     * @uses Package::setPackingType()
     * @uses Package::setQuantity()
     * @uses Package::setProductMarks()
     * @param string $level
     * @param \StructType\PackingType $packingType
     * @param int $quantity
     * @param \StructType\ProductMarks[] $productMarks
     */
    public function __construct($level = null, \StructType\PackingType $packingType = null, $quantity = null, array $productMarks = array())
    {
        $this
            ->setLevel($level)
            ->setPackingType($packingType)
            ->setQuantity($quantity)
            ->setProductMarks($productMarks);
    }
    /**
     * Get level value
     * @return string
     */
    public function getLevel()
    {
        return $this->level;
    }
    /**
     * Set level value
     * @uses \EnumType\PackageLevelType::valueIsValid()
     * @uses \EnumType\PackageLevelType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $level
     * @return \StructType\Package
     */
    public function setLevel($level = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\PackageLevelType::valueIsValid($level)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $level, implode(', ', \EnumType\PackageLevelType::getValidValues())), __LINE__);
        }
        $this->level = $level;
        return $this;
    }
    /**
     * Get packingType value
     * @return \StructType\PackingType
     */
    public function getPackingType()
    {
        return $this->packingType;
    }
    /**
     * Set packingType value
     * @param \StructType\PackingType $packingType
     * @return \StructType\Package
     */
    public function setPackingType(\StructType\PackingType $packingType = null)
    {
        $this->packingType = $packingType;
        return $this;
    }
    /**
     * Get quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->quantity;
    }
    /**
     * Set quantity value
     * @param int $quantity
     * @return \StructType\Package
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !is_numeric($quantity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantity)), __LINE__);
        }
        $this->quantity = $quantity;
        return $this;
    }
    /**
     * Get productMarks value
     * @return \StructType\ProductMarks[]|null
     */
    public function getProductMarks()
    {
        return $this->productMarks;
    }
    /**
     * Set productMarks value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMarks[] $productMarks
     * @return \StructType\Package
     */
    public function setProductMarks(array $productMarks = array())
    {
        foreach ($productMarks as $packageProductMarksItem) {
            // validation for constraint: itemType
            if (!$packageProductMarksItem instanceof \StructType\ProductMarks) {
                throw new \InvalidArgumentException(sprintf('The productMarks property can only contain items of \StructType\ProductMarks, "%s" given', is_object($packageProductMarksItem) ? get_class($packageProductMarksItem) : gettype($packageProductMarksItem)), __LINE__);
            }
        }
        $this->productMarks = $productMarks;
        return $this;
    }
    /**
     * Add item to productMarks value
     * @throws \InvalidArgumentException
     * @param \StructType\ProductMarks $item
     * @return \StructType\Package
     */
    public function addToProductMarks(\StructType\ProductMarks $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProductMarks) {
            throw new \InvalidArgumentException(sprintf('The productMarks property can only contain items of \StructType\ProductMarks, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->productMarks[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Package
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
