<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PSLModificationOperation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Операция внесения изменений в реестр наименований продукции производителя.
 * @subpackage Structs
 */
class PSLModificationOperation extends AbstractStructBase
{
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $type;
    /**
     * The affectedList
     * Meta informations extracted from the WSDL
     * - documentation: Входящие записи для операции.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductItemList
     */
    public $affectedList;
    /**
     * The resultingList
     * Meta informations extracted from the WSDL
     * - documentation: Получаемые в результате операции записи.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ProductItemList
     */
    public $resultingList;
    /**
     * Constructor method for PSLModificationOperation
     * @uses PSLModificationOperation::setType()
     * @uses PSLModificationOperation::setAffectedList()
     * @uses PSLModificationOperation::setResultingList()
     * @param string $type
     * @param \StructType\ProductItemList $affectedList
     * @param \StructType\ProductItemList $resultingList
     */
    public function __construct($type = null, \StructType\ProductItemList $affectedList = null, \StructType\ProductItemList $resultingList = null)
    {
        $this
            ->setType($type)
            ->setAffectedList($affectedList)
            ->setResultingList($resultingList);
    }
    /**
     * Get type value
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RegisterModificationType::valueIsValid()
     * @uses \EnumType\RegisterModificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\PSLModificationOperation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegisterModificationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RegisterModificationType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get affectedList value
     * @return \StructType\ProductItemList|null
     */
    public function getAffectedList()
    {
        return $this->affectedList;
    }
    /**
     * Set affectedList value
     * @param \StructType\ProductItemList $affectedList
     * @return \StructType\PSLModificationOperation
     */
    public function setAffectedList(\StructType\ProductItemList $affectedList = null)
    {
        $this->affectedList = $affectedList;
        return $this;
    }
    /**
     * Get resultingList value
     * @return \StructType\ProductItemList|null
     */
    public function getResultingList()
    {
        return $this->resultingList;
    }
    /**
     * Set resultingList value
     * @param \StructType\ProductItemList $resultingList
     * @return \StructType\PSLModificationOperation
     */
    public function setResultingList(\StructType\ProductItemList $resultingList = null)
    {
        $this->resultingList = $resultingList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PSLModificationOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
