<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeStockEntriesRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на объединение записей журнала продукции.
 * @subpackage Structs
 */
class MergeStockEntriesRequest extends MercuryApplicationRequest
{
    /**
     * The enterprise
     * Meta informations extracted from the WSDL
     * - documentation: Предприятие.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\Enterprise
     */
    public $enterprise;
    /**
     * The mergeOperation
     * Meta informations extracted from the WSDL
     * - documentation: Складская операция (объединение записей журнала продукции).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\MergeStockEntriesOperation
     */
    public $mergeOperation;
    /**
     * Constructor method for MergeStockEntriesRequest
     * @uses MergeStockEntriesRequest::setEnterprise()
     * @uses MergeStockEntriesRequest::setMergeOperation()
     * @param \StructType\Enterprise $enterprise
     * @param \StructType\MergeStockEntriesOperation $mergeOperation
     */
    public function __construct(\StructType\Enterprise $enterprise = null, \StructType\MergeStockEntriesOperation $mergeOperation = null)
    {
        $this
            ->setEnterprise($enterprise)
            ->setMergeOperation($mergeOperation);
    }
    /**
     * Get enterprise value
     * @return \StructType\Enterprise
     */
    public function getEnterprise()
    {
        return $this->enterprise;
    }
    /**
     * Set enterprise value
     * @param \StructType\Enterprise $enterprise
     * @return \StructType\MergeStockEntriesRequest
     */
    public function setEnterprise(\StructType\Enterprise $enterprise = null)
    {
        $this->enterprise = $enterprise;
        return $this;
    }
    /**
     * Get mergeOperation value
     * @return \StructType\MergeStockEntriesOperation
     */
    public function getMergeOperation()
    {
        return $this->mergeOperation;
    }
    /**
     * Set mergeOperation value
     * @param \StructType\MergeStockEntriesOperation $mergeOperation
     * @return \StructType\MergeStockEntriesRequest
     */
    public function setMergeOperation(\StructType\MergeStockEntriesOperation $mergeOperation = null)
    {
        $this->mergeOperation = $mergeOperation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MergeStockEntriesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
