<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MergeStockEntriesOperation StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий производственную операцию.
 * @subpackage Structs
 */
class MergeStockEntriesOperation extends AbstractStructBase
{
    /**
     * The sourceStockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Объединяемые записи журнала
     * - maxOccurs: unbounded
     * - minOccurs: 2
     * @var \StructType\StockEntry[]
     */
    public $sourceStockEntry;
    /**
     * The type
     * Meta informations extracted from the WSDL
     * - documentation: Тип операции. Поддерживается два типа: MERGE и ATTACH. Если элемент не указан, по умолчанию значение принимается равным MERGE. В случае
     * присоединения записей (ATTACH) главной записью журнала (к которой осуществляется присоединение), будет считать первая запись sourceStockEntry из
     * списка. В случае присоединения элемент batch не указывается, результирующая запись журнала будет иметь то же наименование продукции, что и
     * главная. Объём и количество упаковок будет просуммировано, виду упаковки, номера партий логически объединены в список. Результирующая
     * запись журнала продукции будет иметь тот же GUID, что и главная.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $type;
    /**
     * The resultStockEntry
     * Meta informations extracted from the WSDL
     * - documentation: Партия, полученная в результате объединения.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\StockEntry[]
     */
    public $resultStockEntry;
    /**
     * Constructor method for MergeStockEntriesOperation
     * @uses MergeStockEntriesOperation::setSourceStockEntry()
     * @uses MergeStockEntriesOperation::setType()
     * @uses MergeStockEntriesOperation::setResultStockEntry()
     * @param \StructType\StockEntry[] $sourceStockEntry
     * @param string $type
     * @param \StructType\StockEntry[] $resultStockEntry
     */
    public function __construct(array $sourceStockEntry = array(), $type = null, array $resultStockEntry = array())
    {
        $this
            ->setSourceStockEntry($sourceStockEntry)
            ->setType($type)
            ->setResultStockEntry($resultStockEntry);
    }
    /**
     * Get sourceStockEntry value
     * @return \StructType\StockEntry[]
     */
    public function getSourceStockEntry()
    {
        return $this->sourceStockEntry;
    }
    /**
     * Set sourceStockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $sourceStockEntry
     * @return \StructType\MergeStockEntriesOperation
     */
    public function setSourceStockEntry(array $sourceStockEntry = array())
    {
        foreach ($sourceStockEntry as $mergeStockEntriesOperationSourceStockEntryItem) {
            // validation for constraint: itemType
            if (!$mergeStockEntriesOperationSourceStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The sourceStockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($mergeStockEntriesOperationSourceStockEntryItem) ? get_class($mergeStockEntriesOperationSourceStockEntryItem) : gettype($mergeStockEntriesOperationSourceStockEntryItem)), __LINE__);
            }
        }
        $this->sourceStockEntry = $sourceStockEntry;
        return $this;
    }
    /**
     * Add item to sourceStockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\MergeStockEntriesOperation
     */
    public function addToSourceStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The sourceStockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->sourceStockEntry[] = $item;
        return $this;
    }
    /**
     * Get type value
     * @return string|null
     */
    public function getType()
    {
        return $this->type;
    }
    /**
     * Set type value
     * @uses \EnumType\RegisterModificationType::valueIsValid()
     * @uses \EnumType\RegisterModificationType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\MergeStockEntriesOperation
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RegisterModificationType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $type, implode(', ', \EnumType\RegisterModificationType::getValidValues())), __LINE__);
        }
        $this->type = $type;
        return $this;
    }
    /**
     * Get resultStockEntry value
     * @return \StructType\StockEntry[]|null
     */
    public function getResultStockEntry()
    {
        return $this->resultStockEntry;
    }
    /**
     * Set resultStockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry[] $resultStockEntry
     * @return \StructType\MergeStockEntriesOperation
     */
    public function setResultStockEntry(array $resultStockEntry = array())
    {
        foreach ($resultStockEntry as $mergeStockEntriesOperationResultStockEntryItem) {
            // validation for constraint: itemType
            if (!$mergeStockEntriesOperationResultStockEntryItem instanceof \StructType\StockEntry) {
                throw new \InvalidArgumentException(sprintf('The resultStockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($mergeStockEntriesOperationResultStockEntryItem) ? get_class($mergeStockEntriesOperationResultStockEntryItem) : gettype($mergeStockEntriesOperationResultStockEntryItem)), __LINE__);
            }
        }
        $this->resultStockEntry = $resultStockEntry;
        return $this;
    }
    /**
     * Add item to resultStockEntry value
     * @throws \InvalidArgumentException
     * @param \StructType\StockEntry $item
     * @return \StructType\MergeStockEntriesOperation
     */
    public function addToResultStockEntry(\StructType\StockEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\StockEntry) {
            throw new \InvalidArgumentException(sprintf('The resultStockEntry property can only contain items of \StructType\StockEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->resultStockEntry[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MergeStockEntriesOperation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
