<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LocalityList StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип-обертка для списка населенных пунктов.
 * @subpackage Structs
 */
class LocalityList extends EntityList
{
    /**
     * The locality
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Locality[]
     */
    public $locality;
    /**
     * Constructor method for LocalityList
     * @uses LocalityList::setLocality()
     * @param \StructType\Locality[] $locality
     */
    public function __construct(array $locality = array())
    {
        $this
            ->setLocality($locality);
    }
    /**
     * Get locality value
     * @return \StructType\Locality[]|null
     */
    public function getLocality()
    {
        return $this->locality;
    }
    /**
     * Set locality value
     * @throws \InvalidArgumentException
     * @param \StructType\Locality[] $locality
     * @return \StructType\LocalityList
     */
    public function setLocality(array $locality = array())
    {
        foreach ($locality as $localityListLocalityItem) {
            // validation for constraint: itemType
            if (!$localityListLocalityItem instanceof \StructType\Locality) {
                throw new \InvalidArgumentException(sprintf('The locality property can only contain items of \StructType\Locality, "%s" given', is_object($localityListLocalityItem) ? get_class($localityListLocalityItem) : gettype($localityListLocalityItem)), __LINE__);
            }
        }
        $this->locality = $locality;
        return $this;
    }
    /**
     * Add item to locality value
     * @throws \InvalidArgumentException
     * @param \StructType\Locality $item
     * @return \StructType\LocalityList
     */
    public function addToLocality(\StructType\Locality $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Locality) {
            throw new \InvalidArgumentException(sprintf('The locality property can only contain items of \StructType\Locality, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->locality[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LocalityList
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
