<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncorporationForm StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, описывающий элементы справочника ОПФ
 * @subpackage Structs
 */
class IncorporationForm extends GenericEntity
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $name;
    /**
     * The code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $code;
    /**
     * The shortName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - documentation: Строковый тип с ограничением максимальной длины.
     * - maxLength: 255
     * @var string
     */
    public $shortName;
    /**
     * Constructor method for IncorporationForm
     * @uses IncorporationForm::setName()
     * @uses IncorporationForm::setCode()
     * @uses IncorporationForm::setShortName()
     * @param string $name
     * @param string $code
     * @param string $shortName
     */
    public function __construct($name = null, $code = null, $shortName = null)
    {
        $this
            ->setName($name)
            ->setCode($code)
            ->setShortName($shortName);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\IncorporationForm
     */
    public function setName($name = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($name) && strlen($name) > 255) || (is_array($name) && count($name) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($name) ? strlen($name) : count($name)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->code;
    }
    /**
     * Set code value
     * @param string $code
     * @return \StructType\IncorporationForm
     */
    public function setCode($code = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($code) && strlen($code) > 255) || (is_array($code) && count($code) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($code) ? strlen($code) : count($code)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->code = $code;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \StructType\IncorporationForm
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shortName) && strlen($shortName) > 255) || (is_array($shortName) && count($shortName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shortName) ? strlen($shortName) : count($shortName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncorporationForm
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
