<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetVetDocumentChangesListRequest StructType
 * Meta informations extracted from the WSDL
 * - documentation: Заявка на получение списка версий, созданных или измененных за указанный интервал дат. | Параметры запрашиваемого списка. |
 * Интервал времени обновления. В список попадают все записи, дата обновлений которых попадает в указанный интервал. | Идентификатор
 * предприятия, по которому производится поиск записей. | Тип ветсертификата. | Статус ветсертификата.
 * @subpackage Structs
 */
class GetVetDocumentChangesListRequest extends MercuryApplicationRequest
{
    /**
     * The updateDateInterval
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: bs:updateDateInterval
     * @var \StructType\DateInterval
     */
    public $updateDateInterval;
    /**
     * The enterpriseGuid
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * - ref: dt:enterpriseGuid
     * - documentation: Тип, описывающий уникальный идентификатор любой сущности системы.
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $enterpriseGuid;
    /**
     * The listOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: bs:listOptions
     * @var \StructType\ListOptions
     */
    public $listOptions;
    /**
     * The vetDocumentType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:vetDocumentType
     * @var string
     */
    public $vetDocumentType;
    /**
     * The vetDocumentStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * - ref: vd:vetDocumentStatus
     * @var string
     */
    public $vetDocumentStatus;
    /**
     * Constructor method for GetVetDocumentChangesListRequest
     * @uses GetVetDocumentChangesListRequest::setUpdateDateInterval()
     * @uses GetVetDocumentChangesListRequest::setEnterpriseGuid()
     * @uses GetVetDocumentChangesListRequest::setListOptions()
     * @uses GetVetDocumentChangesListRequest::setVetDocumentType()
     * @uses GetVetDocumentChangesListRequest::setVetDocumentStatus()
     * @param \StructType\DateInterval $updateDateInterval
     * @param string $enterpriseGuid
     * @param \StructType\ListOptions $listOptions
     * @param string $vetDocumentType
     * @param string $vetDocumentStatus
     */
    public function __construct(\StructType\DateInterval $updateDateInterval = null, $enterpriseGuid = null, \StructType\ListOptions $listOptions = null, $vetDocumentType = null, $vetDocumentStatus = null)
    {
        $this
            ->setUpdateDateInterval($updateDateInterval)
            ->setEnterpriseGuid($enterpriseGuid)
            ->setListOptions($listOptions)
            ->setVetDocumentType($vetDocumentType)
            ->setVetDocumentStatus($vetDocumentStatus);
    }
    /**
     * Get updateDateInterval value
     * @return \StructType\DateInterval
     */
    public function getUpdateDateInterval()
    {
        return $this->updateDateInterval;
    }
    /**
     * Set updateDateInterval value
     * @param \StructType\DateInterval $updateDateInterval
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public function setUpdateDateInterval(\StructType\DateInterval $updateDateInterval = null)
    {
        $this->updateDateInterval = $updateDateInterval;
        return $this;
    }
    /**
     * Get enterpriseGuid value
     * @return string
     */
    public function getEnterpriseGuid()
    {
        return $this->enterpriseGuid;
    }
    /**
     * Set enterpriseGuid value
     * @param string $enterpriseGuid
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public function setEnterpriseGuid($enterpriseGuid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($enterpriseGuid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($enterpriseGuid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($enterpriseGuid) && !is_string($enterpriseGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($enterpriseGuid)), __LINE__);
        }
        $this->enterpriseGuid = $enterpriseGuid;
        return $this;
    }
    /**
     * Get listOptions value
     * @return \StructType\ListOptions|null
     */
    public function getListOptions()
    {
        return $this->listOptions;
    }
    /**
     * Set listOptions value
     * @param \StructType\ListOptions $listOptions
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public function setListOptions(\StructType\ListOptions $listOptions = null)
    {
        $this->listOptions = $listOptions;
        return $this;
    }
    /**
     * Get vetDocumentType value
     * @return string|null
     */
    public function getVetDocumentType()
    {
        return $this->vetDocumentType;
    }
    /**
     * Set vetDocumentType value
     * @uses \EnumType\VetDocumentType::valueIsValid()
     * @uses \EnumType\VetDocumentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDocumentType
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public function setVetDocumentType($vetDocumentType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentType::valueIsValid($vetDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDocumentType, implode(', ', \EnumType\VetDocumentType::getValidValues())), __LINE__);
        }
        $this->vetDocumentType = $vetDocumentType;
        return $this;
    }
    /**
     * Get vetDocumentStatus value
     * @return string|null
     */
    public function getVetDocumentStatus()
    {
        return $this->vetDocumentStatus;
    }
    /**
     * Set vetDocumentStatus value
     * @uses \EnumType\VetDocumentStatus::valueIsValid()
     * @uses \EnumType\VetDocumentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $vetDocumentStatus
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public function setVetDocumentStatus($vetDocumentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VetDocumentStatus::valueIsValid($vetDocumentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $vetDocumentStatus, implode(', ', \EnumType\VetDocumentStatus::getValidValues())), __LINE__);
        }
        $this->vetDocumentStatus = $vetDocumentStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetVetDocumentChangesListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
