<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GenericVersioningEntity StructType
 * Meta informations extracted from the WSDL
 * - documentation: Тип, базовый для сущностей, поддерживающих версии.
 * @subpackage Structs
 */
class GenericVersioningEntity extends GenericEntity
{
    /**
     * The guid
     * Meta informations extracted from the WSDL
     * - documentation: Глобальный идентификатор в системах Россельхознадзора. | Тип, описывающий уникальный идентификатор любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $guid;
    /**
     * The active
     * Meta informations extracted from the WSDL
     * - documentation: Флаг, определяющий актуальность записи.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $active;
    /**
     * The last
     * Meta informations extracted from the WSDL
     * - documentation: Флаг, указывающий на то, что запись является последней в истории.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $last;
    /**
     * The status
     * Meta informations extracted from the WSDL
     * - documentation: Статус объекта. | Тип, описывающий статусы версионных объектов. 100 - CREATED - Запись создана 110 CREATED_WHEN_MERGE - Запись создана в
     * результате объединения двух или более других 120 - CREATED_WHEN_SPLIT - Запись создана в результате разделения другой 200 - UPDATED - В запись были
     * внесены изменения 230 - UPDATED_WHEN_ATTACH - Запись была обновлена в результате присоединения другой 240 - UPDATED_WHEN_FORK - Запись была обновлена в
     * результате отделения от неё другой 300 - MOVED - Запись была перемещена в другую группу (для иерархических справочников) 400 - DELETED - Запись была
     * удалена 410 - DELETED_WHEN_MERGE - Запись была удалена в результате объединения 420 - DELETED_WHEN_SPLIT - Запись была удалена в результате разделения 430 -
     * DELETED_WHEN_ATTACH - Запись была удалена в результате присоединения
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [1-4][0-9][0-9]
     * @var int
     */
    public $status;
    /**
     * The createDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата создания объекта.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $createDate;
    /**
     * The updateDate
     * Meta informations extracted from the WSDL
     * - documentation: Дата последнего обновления объекта.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $updateDate;
    /**
     * The previous
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор предыдущей версии объекта. | Тип, описывающий уникальный идентификатор любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $previous;
    /**
     * The next
     * Meta informations extracted from the WSDL
     * - documentation: Идентификатор последующей версии объекта. | Тип, описывающий уникальный идентификатор любой сущности системы.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}
     * @var string
     */
    public $next;
    /**
     * Constructor method for GenericVersioningEntity
     * @uses GenericVersioningEntity::setGuid()
     * @uses GenericVersioningEntity::setActive()
     * @uses GenericVersioningEntity::setLast()
     * @uses GenericVersioningEntity::setStatus()
     * @uses GenericVersioningEntity::setCreateDate()
     * @uses GenericVersioningEntity::setUpdateDate()
     * @uses GenericVersioningEntity::setPrevious()
     * @uses GenericVersioningEntity::setNext()
     * @param string $guid
     * @param bool $active
     * @param bool $last
     * @param int $status
     * @param string $createDate
     * @param string $updateDate
     * @param string $previous
     * @param string $next
     */
    public function __construct($guid = null, $active = null, $last = null, $status = null, $createDate = null, $updateDate = null, $previous = null, $next = null)
    {
        $this
            ->setGuid($guid)
            ->setActive($active)
            ->setLast($last)
            ->setStatus($status)
            ->setCreateDate($createDate)
            ->setUpdateDate($updateDate)
            ->setPrevious($previous)
            ->setNext($next);
    }
    /**
     * Get guid value
     * @return string|null
     */
    public function getGuid()
    {
        return $this->guid;
    }
    /**
     * Set guid value
     * @param string $guid
     * @return \StructType\GenericVersioningEntity
     */
    public function setGuid($guid = null)
    {
        // validation for constraint: pattern
        if (is_scalar($guid) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($guid, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($guid) && !is_string($guid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($guid)), __LINE__);
        }
        $this->guid = $guid;
        return $this;
    }
    /**
     * Get active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->active;
    }
    /**
     * Set active value
     * @param bool $active
     * @return \StructType\GenericVersioningEntity
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($active)), __LINE__);
        }
        $this->active = $active;
        return $this;
    }
    /**
     * Get last value
     * @return bool|null
     */
    public function getLast()
    {
        return $this->last;
    }
    /**
     * Set last value
     * @param bool $last
     * @return \StructType\GenericVersioningEntity
     */
    public function setLast($last = null)
    {
        // validation for constraint: boolean
        if (!is_null($last) && !is_bool($last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($last)), __LINE__);
        }
        $this->last = $last;
        return $this;
    }
    /**
     * Get status value
     * @return int|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param int $status
     * @return \StructType\GenericVersioningEntity
     */
    public function setStatus($status = null)
    {
        // validation for constraint: pattern
        if (is_scalar($status) && !preg_match('/[1-4][0-9][0-9]/', $status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[1-4][0-9][0-9]", "%s" given', var_export($status, true)), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($status) && !is_numeric($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($status)), __LINE__);
        }
        $this->status = $status;
        return $this;
    }
    /**
     * Get createDate value
     * @return string|null
     */
    public function getCreateDate()
    {
        return $this->createDate;
    }
    /**
     * Set createDate value
     * @param string $createDate
     * @return \StructType\GenericVersioningEntity
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createDate)), __LINE__);
        }
        $this->createDate = $createDate;
        return $this;
    }
    /**
     * Get updateDate value
     * @return string|null
     */
    public function getUpdateDate()
    {
        return $this->updateDate;
    }
    /**
     * Set updateDate value
     * @param string $updateDate
     * @return \StructType\GenericVersioningEntity
     */
    public function setUpdateDate($updateDate = null)
    {
        // validation for constraint: string
        if (!is_null($updateDate) && !is_string($updateDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateDate)), __LINE__);
        }
        $this->updateDate = $updateDate;
        return $this;
    }
    /**
     * Get previous value
     * @return string|null
     */
    public function getPrevious()
    {
        return $this->previous;
    }
    /**
     * Set previous value
     * @param string $previous
     * @return \StructType\GenericVersioningEntity
     */
    public function setPrevious($previous = null)
    {
        // validation for constraint: pattern
        if (is_scalar($previous) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $previous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($previous, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($previous) && !is_string($previous)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($previous)), __LINE__);
        }
        $this->previous = $previous;
        return $this;
    }
    /**
     * Get next value
     * @return string|null
     */
    public function getNext()
    {
        return $this->next;
    }
    /**
     * Set next value
     * @param string $next
     * @return \StructType\GenericVersioningEntity
     */
    public function setNext($next = null)
    {
        // validation for constraint: pattern
        if (is_scalar($next) && !preg_match('/[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}/', $next)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}", "%s" given', var_export($next, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($next) && !is_string($next)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($next)), __LINE__);
        }
        $this->next = $next;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GenericVersioningEntity
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
