<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FederalDistrict StructType
 * @subpackage Structs
 */
class FederalDistrict extends GenericVersioningEntity
{
    /**
     * The fullName
     * Meta informations extracted from the WSDL
     * - documentation: Полное название (содержить "федеральный округ"). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $fullName;
    /**
     * The shortName
     * Meta informations extracted from the WSDL
     * - documentation: Короткое название (без "федеральный округ"). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $shortName;
    /**
     * The abbreviation
     * Meta informations extracted from the WSDL
     * - documentation: Аббревиатура. | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $abbreviation;
    /**
     * Constructor method for FederalDistrict
     * @uses FederalDistrict::setFullName()
     * @uses FederalDistrict::setShortName()
     * @uses FederalDistrict::setAbbreviation()
     * @param string $fullName
     * @param string $shortName
     * @param string $abbreviation
     */
    public function __construct($fullName = null, $shortName = null, $abbreviation = null)
    {
        $this
            ->setFullName($fullName)
            ->setShortName($shortName)
            ->setAbbreviation($abbreviation);
    }
    /**
     * Get fullName value
     * @return string|null
     */
    public function getFullName()
    {
        return $this->fullName;
    }
    /**
     * Set fullName value
     * @param string $fullName
     * @return \StructType\FederalDistrict
     */
    public function setFullName($fullName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($fullName) && strlen($fullName) > 255) || (is_array($fullName) && count($fullName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($fullName) ? strlen($fullName) : count($fullName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($fullName) && !is_string($fullName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fullName)), __LINE__);
        }
        $this->fullName = $fullName;
        return $this;
    }
    /**
     * Get shortName value
     * @return string|null
     */
    public function getShortName()
    {
        return $this->shortName;
    }
    /**
     * Set shortName value
     * @param string $shortName
     * @return \StructType\FederalDistrict
     */
    public function setShortName($shortName = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($shortName) && strlen($shortName) > 255) || (is_array($shortName) && count($shortName) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($shortName) ? strlen($shortName) : count($shortName)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($shortName) && !is_string($shortName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($shortName)), __LINE__);
        }
        $this->shortName = $shortName;
        return $this;
    }
    /**
     * Get abbreviation value
     * @return string|null
     */
    public function getAbbreviation()
    {
        return $this->abbreviation;
    }
    /**
     * Set abbreviation value
     * @param string $abbreviation
     * @return \StructType\FederalDistrict
     */
    public function setAbbreviation($abbreviation = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($abbreviation) && strlen($abbreviation) > 255) || (is_array($abbreviation) && count($abbreviation) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($abbreviation) ? strlen($abbreviation) : count($abbreviation)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($abbreviation) && !is_string($abbreviation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($abbreviation)), __LINE__);
        }
        $this->abbreviation = $abbreviation;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FederalDistrict
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
