<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EnterpriseOfficialRegistration StructType
 * Meta informations extracted from the WSDL
 * - documentation: Факт постановки предприятия на учёт в налоговом органе.
 * @subpackage Structs
 */
class EnterpriseOfficialRegistration extends AbstractStructBase
{
    /**
     * The businessEntity
     * Meta informations extracted from the WSDL
     * - documentation: Хозяйствующий субъект, поставивший площадку на учёт в налоговом органе. Для элемента могут быть указаны атрибуты: UUID, GUID, (NAME +
     * INN), (NAME + OGRN).
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BusinessEntity
     */
    public $businessEntity;
    /**
     * The kpp
     * Meta informations extracted from the WSDL
     * - documentation: Код причины постановки на учёт (КПП). | Строковый тип с ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 1
     * - maxLength: 255
     * @var string
     */
    public $kpp;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - documentation: Государственный номер регистрации ФНС. | Тип, описывающий государственный регистрационный номер (ГРН). | Строковый тип с
     * ограничением максимальной длины.
     * - maxOccurs: 1
     * - minOccurs: 0
     * - maxLength: 255
     * @var string
     */
    public $ID;
    /**
     * Constructor method for EnterpriseOfficialRegistration
     * @uses EnterpriseOfficialRegistration::setBusinessEntity()
     * @uses EnterpriseOfficialRegistration::setKpp()
     * @uses EnterpriseOfficialRegistration::setID()
     * @param \StructType\BusinessEntity $businessEntity
     * @param string $kpp
     * @param string $iD
     */
    public function __construct(\StructType\BusinessEntity $businessEntity = null, $kpp = null, $iD = null)
    {
        $this
            ->setBusinessEntity($businessEntity)
            ->setKpp($kpp)
            ->setID($iD);
    }
    /**
     * Get businessEntity value
     * @return \StructType\BusinessEntity
     */
    public function getBusinessEntity()
    {
        return $this->businessEntity;
    }
    /**
     * Set businessEntity value
     * @param \StructType\BusinessEntity $businessEntity
     * @return \StructType\EnterpriseOfficialRegistration
     */
    public function setBusinessEntity(\StructType\BusinessEntity $businessEntity = null)
    {
        $this->businessEntity = $businessEntity;
        return $this;
    }
    /**
     * Get kpp value
     * @return string
     */
    public function getKpp()
    {
        return $this->kpp;
    }
    /**
     * Set kpp value
     * @param string $kpp
     * @return \StructType\EnterpriseOfficialRegistration
     */
    public function setKpp($kpp = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($kpp) && strlen($kpp) > 255) || (is_array($kpp) && count($kpp) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($kpp) ? strlen($kpp) : count($kpp)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($kpp) && !is_string($kpp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($kpp)), __LINE__);
        }
        $this->kpp = $kpp;
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\EnterpriseOfficialRegistration
     */
    public function setID($iD = null)
    {
        // validation for constraint: maxLength
        if ((is_scalar($iD) && strlen($iD) > 255) || (is_array($iD) && count($iD) > 255)) {
            throw new \InvalidArgumentException(sprintf('Invalid length, please provide an array with 255 element(s) or a scalar of 255 character(s) at most, "%d" length given', is_scalar($iD) ? strlen($iD) : count($iD)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EnterpriseOfficialRegistration
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
